/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CORSConfiguration;
import io.fusionauth.domain.RequiresCORSConfiguration;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.DomainBasedIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.SAMLv2ApplicationConfiguration;
import io.fusionauth.domain.util.HTTPMethod;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class SAMLv2IdentityProvider
extends BaseIdentityProvider<SAMLv2ApplicationConfiguration>
implements Buildable<SAMLv2IdentityProvider>,
DomainBasedIdentityProvider,
RequiresCORSConfiguration {
    public final Set<String> domains = new HashSet<String>();
    @InternalJSONColumn
    public URI buttonImageURL;
    @InternalJSONColumn
    public String buttonText;
    @InternalJSONColumn
    public String emailClaim;
    @InternalJSONColumn
    public URI idpEndpoint;
    @Deprecated
    @InternalJSONColumn
    public String issuer;
    public UUID keyId;
    @InternalJSONColumn
    public boolean useNameIdForEmail;

    @Override
    @JsonIgnore
    public CORSConfiguration corsConfiguration() {
        return new CORSConfiguration().with(override -> override.allowedMethods.add(HTTPMethod.POST)).with(override -> override.allowedOrigins.add(URI.create(this.idpEndpoint.getScheme() + "://" + this.idpEndpoint.getHost() + (this.idpEndpoint.getPort() == -1 ? "" : ":" + this.idpEndpoint.getPort()))));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SAMLv2IdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SAMLv2IdentityProvider that = (SAMLv2IdentityProvider)o;
        return this.useNameIdForEmail == that.useNameIdForEmail && Objects.equals(this.domains, that.domains) && Objects.equals(this.buttonImageURL, that.buttonImageURL) && Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.emailClaim, that.emailClaim) && Objects.equals(this.idpEndpoint, that.idpEndpoint) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.keyId, that.keyId);
    }

    @Override
    public Set<String> getDomains() {
        return this.domains;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.SAMLv2;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domains, this.buttonImageURL, this.buttonText, this.emailClaim, this.idpEndpoint, this.issuer, this.keyId, this.useNameIdForEmail);
    }

    public URI lookupButtonImageURL(String clientId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(clientId, (D app) -> app.buttonImageURL));
    }

    public URI lookupButtonImageURL(UUID applicationId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(applicationId, (D app) -> app.buttonImageURL));
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    @Override
    public void normalize() {
        super.normalize();
        this.normalizeDomains();
    }

    public SAMLv2IdentityProvider secure() {
        this.domains.clear();
        this.emailClaim = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

