/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;

public class Theme
implements Buildable<Theme>,
_InternalJSONColumn {
    public static final UUID FUSIONAUTH_THEME_ID = UUID.fromString("75a068fd-e94b-451a-9aeb-3ddb9a3b5987");
    public Map<String, Object> data = new HashMap<String, Object>();
    @InternalJSONColumn
    public String defaultMessages;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    @InternalJSONColumn
    public LocalizedStrings localizedMessages = new LocalizedStrings();
    public String name;
    @InternalJSONColumn
    public String stylesheet;
    @InternalJSONColumn
    public Templates templates;

    public Theme() {
    }

    public Theme(Theme theme) {
        this.data.putAll(theme.data);
        this.defaultMessages = theme.defaultMessages;
        this.id = theme.id;
        this.insertInstant = theme.insertInstant;
        this.lastUpdateInstant = theme.lastUpdateInstant;
        this.localizedMessages.putAll(theme.localizedMessages);
        this.name = theme.name;
        this.stylesheet = theme.stylesheet;
        if (theme.templates != null) {
            this.templates = new Templates(theme.templates);
        }
    }

    public Set<Locale> additionalLocales() {
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Theme)) {
            return false;
        }
        Theme that = (Theme)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.defaultMessages, that.defaultMessages) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.localizedMessages, that.localizedMessages) && Objects.equals(this.name, that.name) && Objects.equals(this.stylesheet, that.stylesheet) && Objects.equals(this.templates, that.templates);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.defaultMessages, this.id, this.insertInstant, this.lastUpdateInstant, this.localizedMessages, this.name, this.stylesheet, this.templates);
    }

    public String message(String key, Object ... arguments) {
        return "";
    }

    @JsonIgnore
    public boolean missingTemplate() {
        if (this.templates == null) {
            return true;
        }
        return Stream.of(this.templates.emailComplete, this.templates.emailSend, this.templates.emailVerify, this.templates.helpers, this.templates.oauth2Authorize, this.templates.oauth2ChildRegistrationNotAllowed, this.templates.oauth2ChildRegistrationNotAllowedComplete, this.templates.oauth2CompleteRegistration, this.templates.oauth2Device, this.templates.oauth2DeviceComplete, this.templates.oauth2Error, this.templates.oauth2Logout, this.templates.oauth2Passwordless, this.templates.oauth2Register, this.templates.oauth2TwoFactor, this.templates.oauth2Wait, this.templates.passwordChange, this.templates.passwordComplete, this.templates.passwordForgot, this.templates.passwordSent, this.templates.registrationComplete, this.templates.registrationSend, this.templates.registrationVerify, this.templates.samlv2Logout).anyMatch(Objects::isNull);
    }

    public void normalize() {
        if (this.defaultMessages != null) {
            this.defaultMessages = Normalizer.lineReturns(this.defaultMessages);
        }
        if (this.templates != null) {
            this.templates.normalize();
        }
        if (this.localizedMessages != null) {
            this.localizedMessages.normalize();
        }
        this.stylesheet = Normalizer.lineReturns(this.stylesheet);
    }

    public String optionalMessage(String key, Object ... arguments) {
        return "";
    }

    public String stylesheet() {
        if (this.stylesheet == null) {
            return "";
        }
        return Normalizer.lineReturns(this.stylesheet);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class Templates
    implements Buildable<Templates> {
        public static final Set<String> suppliers = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("emailComplete", "emailSend", "emailVerify", "helpers", "oauth2Authorize", "oauth2ChildRegistrationNotAllowed", "oauth2ChildRegistrationNotAllowedComplete", "oauth2CompleteRegistration", "oauth2Device", "oauth2DeviceComplete", "oauth2Error", "oauth2Logout", "oauth2Passwordless", "oauth2Register", "oauth2TwoFactor", "passwordChange", "passwordComplete", "passwordForgot", "passwordSent", "registrationComplete", "registrationSend", "registrationVerify", "samlv2Logout")));
        public String emailComplete;
        public String emailSend;
        public String emailVerify;
        public String helpers;
        public String oauth2Authorize;
        public String oauth2ChildRegistrationNotAllowed;
        public String oauth2ChildRegistrationNotAllowedComplete;
        public String oauth2CompleteRegistration;
        public String oauth2Device;
        public String oauth2DeviceComplete;
        public String oauth2Error;
        public String oauth2Logout;
        public String oauth2Passwordless;
        public String oauth2Register;
        public String oauth2TwoFactor;
        public String oauth2Wait;
        public String passwordChange;
        public String passwordComplete;
        public String passwordForgot;
        public String passwordSent;
        public String registrationComplete;
        public String registrationSend;
        public String registrationVerify;
        public String samlv2Logout;

        public Templates() {
        }

        public Templates(Templates other) {
            this.emailComplete = other.emailComplete;
            this.emailSend = other.emailSend;
            this.emailVerify = other.emailVerify;
            this.helpers = other.helpers;
            this.oauth2Authorize = other.oauth2Authorize;
            this.oauth2ChildRegistrationNotAllowed = other.oauth2ChildRegistrationNotAllowed;
            this.oauth2ChildRegistrationNotAllowedComplete = other.oauth2ChildRegistrationNotAllowedComplete;
            this.oauth2CompleteRegistration = other.oauth2CompleteRegistration;
            this.oauth2Device = other.oauth2Device;
            this.oauth2DeviceComplete = other.oauth2DeviceComplete;
            this.oauth2Error = other.oauth2Error;
            this.oauth2Logout = other.oauth2Logout;
            this.oauth2Passwordless = other.oauth2Passwordless;
            this.oauth2Register = other.oauth2Register;
            this.oauth2TwoFactor = other.oauth2TwoFactor;
            this.oauth2Wait = other.oauth2Wait;
            this.passwordChange = other.passwordChange;
            this.passwordComplete = other.passwordComplete;
            this.passwordForgot = other.passwordForgot;
            this.passwordSent = other.passwordSent;
            this.registrationComplete = other.registrationComplete;
            this.registrationSend = other.registrationSend;
            this.registrationVerify = other.registrationVerify;
            this.samlv2Logout = other.samlv2Logout;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Templates that = (Templates)o;
            return Objects.equals(this.emailComplete, that.emailComplete) && Objects.equals(this.emailSend, that.emailSend) && Objects.equals(this.emailVerify, that.emailVerify) && Objects.equals(this.helpers, that.helpers) && Objects.equals(this.oauth2Authorize, that.oauth2Authorize) && Objects.equals(this.oauth2ChildRegistrationNotAllowed, that.oauth2ChildRegistrationNotAllowed) && Objects.equals(this.oauth2ChildRegistrationNotAllowedComplete, that.oauth2ChildRegistrationNotAllowedComplete) && Objects.equals(this.oauth2CompleteRegistration, that.oauth2CompleteRegistration) && Objects.equals(this.oauth2Device, that.oauth2Device) && Objects.equals(this.oauth2DeviceComplete, that.oauth2DeviceComplete) && Objects.equals(this.oauth2Error, that.oauth2Error) && Objects.equals(this.oauth2Logout, that.oauth2Logout) && Objects.equals(this.oauth2Passwordless, that.oauth2Passwordless) && Objects.equals(this.oauth2Register, that.oauth2Register) && Objects.equals(this.oauth2TwoFactor, that.oauth2TwoFactor) && Objects.equals(this.oauth2Wait, that.oauth2Wait) && Objects.equals(this.passwordChange, that.passwordChange) && Objects.equals(this.passwordComplete, that.passwordComplete) && Objects.equals(this.passwordForgot, that.passwordForgot) && Objects.equals(this.passwordSent, that.passwordSent) && Objects.equals(this.registrationComplete, that.registrationComplete) && Objects.equals(this.registrationSend, that.registrationSend) && Objects.equals(this.registrationVerify, that.registrationVerify) && Objects.equals(this.samlv2Logout, that.samlv2Logout);
        }

        public int hashCode() {
            return Objects.hash(this.emailComplete, this.emailSend, this.emailVerify, this.helpers, this.oauth2Authorize, this.oauth2ChildRegistrationNotAllowed, this.oauth2ChildRegistrationNotAllowedComplete, this.oauth2CompleteRegistration, this.oauth2Device, this.oauth2DeviceComplete, this.oauth2Error, this.oauth2Logout, this.oauth2Passwordless, this.oauth2Register, this.oauth2TwoFactor, this.oauth2Wait, this.passwordChange, this.passwordComplete, this.passwordForgot, this.passwordSent, this.registrationComplete, this.registrationSend, this.registrationVerify, this.samlv2Logout);
        }

        public void normalize() {
            this.emailComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.emailComplete));
            this.emailSend = Normalizer.lineReturns(Normalizer.trimToNull(this.emailSend));
            this.emailVerify = Normalizer.lineReturns(Normalizer.trimToNull(this.emailVerify));
            this.helpers = Normalizer.lineReturns(Normalizer.trimToNull(this.helpers));
            this.oauth2Authorize = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Authorize));
            this.oauth2ChildRegistrationNotAllowed = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2ChildRegistrationNotAllowed));
            this.oauth2ChildRegistrationNotAllowedComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2ChildRegistrationNotAllowedComplete));
            this.oauth2CompleteRegistration = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2CompleteRegistration));
            this.oauth2Device = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Device));
            this.oauth2DeviceComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2DeviceComplete));
            this.oauth2Error = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Error));
            this.oauth2Logout = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Logout));
            this.oauth2Passwordless = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Passwordless));
            this.oauth2Register = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Register));
            this.oauth2TwoFactor = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2TwoFactor));
            this.oauth2Wait = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Wait));
            this.passwordChange = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordChange));
            this.passwordComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordComplete));
            this.passwordForgot = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordForgot));
            this.passwordSent = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordSent));
            this.registrationComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationComplete));
            this.registrationSend = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationSend));
            this.registrationVerify = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationVerify));
            this.samlv2Logout = Normalizer.lineReturns(Normalizer.trimToNull(this.samlv2Logout));
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

