/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.jwt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.Tenant;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.jwt.DeviceInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class RefreshToken
implements Buildable<RefreshToken>,
_InternalJSONColumn {
    @JsonIgnore
    public Application application;
    public UUID applicationId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public ZonedDateTime insertInstant;
    @InternalJSONColumn
    public MetaData metaData = new MetaData();
    public ZonedDateTime startInstant;
    public String token;
    public UUID userId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshToken that = (RefreshToken)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.data, that.data) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.metaData, that.metaData) && Objects.equals(this.startInstant, that.startInstant) && Objects.equals(this.token, that.token) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.data, this.id, this.insertInstant, this.metaData, this.startInstant, this.token, this.userId);
    }

    @JsonIgnore
    public boolean isExpired(Tenant tenant, Application application) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        JWTConfiguration jwtConfiguration = tenant.lookupJWTConfiguration(application);
        return this.startInstant.plusMinutes(jwtConfiguration.refreshTokenTimeToLiveInMinutes).isBefore(now);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class MetaData
    implements Buildable<MetaData> {
        public DeviceInfo device = new DeviceInfo();
        public Set<String> scopes;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetaData)) {
                return false;
            }
            MetaData metaData = (MetaData)o;
            return Objects.equals(this.device, metaData.device) && Objects.equals(this.scopes, metaData.scopes);
        }

        public int hashCode() {
            return Objects.hash(this.device, this.scopes);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

