/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EmailUnverifiedOptions;
import io.fusionauth.domain.VerificationStrategy;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import io.fusionauth.domain.util.Normalizer;
import java.util.Objects;
import java.util.UUID;

public class EmailConfiguration
implements Buildable<EmailConfiguration> {
    public String defaultFromEmail = "change-me@example.com";
    public String defaultFromName;
    @ExcludeFromDatabaseDataColumn
    public UUID forgotPasswordEmailTemplateId;
    public String host = "localhost";
    public String password;
    @ExcludeFromDatabaseDataColumn
    public UUID passwordlessEmailTemplateId;
    public Integer port = 25;
    public String properties;
    public EmailSecurityType security;
    @ExcludeFromDatabaseDataColumn
    public UUID setPasswordEmailTemplateId;
    public EmailUnverifiedOptions unverified = new EmailUnverifiedOptions();
    public String username;
    @ExcludeFromDatabaseDataColumn
    public UUID verificationEmailTemplateId;
    public VerificationStrategy verificationStrategy;
    public boolean verifyEmail;
    public boolean verifyEmailWhenChanged;

    @JacksonConstructor
    public EmailConfiguration() {
    }

    public EmailConfiguration(EmailConfiguration other) {
        this.defaultFromEmail = other.defaultFromEmail;
        this.defaultFromName = other.defaultFromName;
        this.forgotPasswordEmailTemplateId = other.forgotPasswordEmailTemplateId;
        this.host = other.host;
        this.password = other.password;
        this.passwordlessEmailTemplateId = other.passwordlessEmailTemplateId;
        this.port = other.port;
        this.properties = other.properties;
        this.security = other.security;
        this.setPasswordEmailTemplateId = other.setPasswordEmailTemplateId;
        this.unverified = new EmailUnverifiedOptions(other.unverified);
        this.username = other.username;
        this.verificationEmailTemplateId = other.verificationEmailTemplateId;
        this.verificationStrategy = other.verificationStrategy;
        this.verifyEmail = other.verifyEmail;
        this.verifyEmailWhenChanged = other.verifyEmailWhenChanged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailConfiguration that = (EmailConfiguration)o;
        return this.verifyEmail == that.verifyEmail && this.verifyEmailWhenChanged == that.verifyEmailWhenChanged && Objects.equals(this.defaultFromEmail, that.defaultFromEmail) && Objects.equals(this.defaultFromName, that.defaultFromName) && Objects.equals(this.forgotPasswordEmailTemplateId, that.forgotPasswordEmailTemplateId) && Objects.equals(this.host, that.host) && Objects.equals(this.password, that.password) && Objects.equals(this.passwordlessEmailTemplateId, that.passwordlessEmailTemplateId) && Objects.equals(this.port, that.port) && Objects.equals(this.properties, that.properties) && this.security == that.security && Objects.equals(this.setPasswordEmailTemplateId, that.setPasswordEmailTemplateId) && Objects.equals(this.unverified, that.unverified) && Objects.equals(this.username, that.username) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId) && this.verificationStrategy == that.verificationStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.defaultFromEmail, this.defaultFromName, this.forgotPasswordEmailTemplateId, this.host, this.password, this.passwordlessEmailTemplateId, this.port, this.properties, this.security, this.setPasswordEmailTemplateId, this.unverified, this.username, this.verificationEmailTemplateId, this.verificationStrategy, this.verifyEmail, this.verifyEmailWhenChanged});
    }

    public void normalize() {
        this.host = Normalizer.trim(this.host);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static enum EmailSecurityType {
        NONE,
        SSL,
        TLS;

    }
}

