/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.DomainBasedIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderOauth2Configuration;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.OpenIdConnectApplicationConfiguration;
import io.fusionauth.domain.provider.SupportsPostBindings;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class OpenIdConnectIdentityProvider
extends BaseIdentityProvider<OpenIdConnectApplicationConfiguration>
implements Buildable<OpenIdConnectIdentityProvider>,
DomainBasedIdentityProvider,
SupportsPostBindings {
    public final Set<String> domains = new HashSet<String>();
    @InternalJSONColumn
    public URI buttonImageURL;
    @InternalJSONColumn
    public String buttonText = "Login with OpenID Connect";
    @InternalJSONColumn
    public IdentityProviderOauth2Configuration oauth2 = new IdentityProviderOauth2Configuration();
    @InternalJSONColumn
    public boolean postRequest;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenIdConnectIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenIdConnectIdentityProvider that = (OpenIdConnectIdentityProvider)o;
        return this.postRequest == that.postRequest && Objects.equals(this.domains, that.domains) && Objects.equals(this.buttonImageURL, that.buttonImageURL) && Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.oauth2, that.oauth2);
    }

    @Override
    public Set<String> getDomains() {
        return this.domains;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.OpenIDConnect;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domains, this.buttonImageURL, this.buttonText, this.oauth2, this.postRequest);
    }

    public URI lookupButtonImageURL(String clientId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(clientId, (D app) -> app.buttonImageURL));
    }

    public URI lookupButtonImageURL(UUID applicationId) {
        return this.lookup(() -> this.buttonImageURL, () -> this.app(applicationId, (D app) -> app.buttonImageURL));
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    public String lookupClientId(String clientId) {
        return this.lookup(() -> this.oauth2.client_id, () -> this.app(clientId, (D app) -> app.oauth2.client_id));
    }

    public String lookupClientId(UUID applicationId) {
        return this.lookup(() -> this.oauth2.client_id, () -> this.app(applicationId, (D app) -> app.oauth2.client_id));
    }

    public String lookupClientSecret(UUID applicationId) {
        return this.lookup(() -> this.oauth2.client_secret, () -> this.app(applicationId, (D app) -> app.oauth2.client_secret));
    }

    public String lookupScope(String clientId) {
        return this.lookup(() -> this.oauth2.scope, () -> this.app(clientId, (D app) -> app.oauth2.scope));
    }

    public String lookupScope(UUID applicationId) {
        return this.lookup(() -> this.oauth2.scope, () -> this.app(applicationId, (D app) -> app.oauth2.scope));
    }

    @Override
    public void normalize() {
        super.normalize();
        this.normalizeDomains();
    }

    @Override
    public boolean postRequestEnabled() {
        return this.postRequest;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

