/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class APIKey
implements Buildable<APIKey> {
    public UUID id;
    public ZonedDateTime insertInstant;
    public String key;
    public boolean keyManager;
    public ZonedDateTime lastUpdateInstant;
    public APIKeyMetaData metaData;
    public APIKeyPermissions permissions;
    public UUID tenantId;

    public APIKey(String key) {
        this.key = key;
    }

    @JacksonConstructor
    public APIKey() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIKey apiKey = (APIKey)o;
        return this.keyManager == apiKey.keyManager && Objects.equals(this.id, apiKey.id) && Objects.equals(this.insertInstant, apiKey.insertInstant) && Objects.equals(this.key, apiKey.key) && Objects.equals(this.lastUpdateInstant, apiKey.lastUpdateInstant) && Objects.equals(this.metaData, apiKey.metaData) && Objects.equals(this.permissions, apiKey.permissions) && Objects.equals(this.tenantId, apiKey.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.insertInstant, this.key, this.keyManager, this.lastUpdateInstant, this.metaData, this.permissions, this.tenantId);
    }

    public void normalize() {
        if (this.permissions != null) {
            this.permissions.endpoints.remove("/api/api-key");
        }
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class APIKeyPermissions {
        public final Map<String, Set<String>> endpoints = new HashMap<String, Set<String>>();

        public APIKeyPermissions() {
        }

        public APIKeyPermissions(Map<String, Set<String>> endpoints) {
            endpoints.entrySet().stream().forEach(e -> {
                Set cfr_ignored_0 = this.endpoints.put((String)e.getKey(), new HashSet((Collection)e.getValue()));
            });
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            APIKeyPermissions that = (APIKeyPermissions)o;
            return Objects.equals(this.endpoints, that.endpoints);
        }

        public int hashCode() {
            return this.endpoints.hashCode();
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class APIKeyMetaData {
        public final Map<String, String> attributes = new HashMap<String, String>();

        public APIKeyMetaData(Map<String, String> attributes) {
            this.attributes.putAll(attributes);
        }

        public APIKeyMetaData() {
        }

        public APIKeyMetaData(String key, String value) {
            this.attributes.put(key, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            APIKeyMetaData that = (APIKeyMetaData)o;
            return Objects.equals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return this.attributes.hashCode();
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

