/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.oauth2.ClientAuthenticationPolicy;
import io.fusionauth.domain.oauth2.GrantType;
import io.fusionauth.domain.oauth2.LogoutBehavior;
import io.fusionauth.domain.oauth2.ProofKeyForCodeExchangePolicy;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class OAuth2Configuration
implements Buildable<OAuth2Configuration> {
    @JsonMerge(value=OptBoolean.FALSE)
    public List<URI> authorizedOriginURLs = new ArrayList<URI>();
    @JsonMerge(value=OptBoolean.FALSE)
    public List<URI> authorizedRedirectURLs = new ArrayList<URI>();
    public ClientAuthenticationPolicy clientAuthenticationPolicy;
    public String clientId;
    public String clientSecret;
    public boolean debug;
    public URI deviceVerificationURL;
    @JsonMerge(value=OptBoolean.FALSE)
    public Set<GrantType> enabledGrants = new TreeSet<GrantType>(Comparator.comparing(GrantType::grantName, Comparator.reverseOrder()));
    public boolean generateRefreshTokens;
    public LogoutBehavior logoutBehavior = LogoutBehavior.AllApplications;
    public URI logoutURL;
    public ProofKeyForCodeExchangePolicy proofKeyForCodeExchangePolicy = ProofKeyForCodeExchangePolicy.NotRequired;
    @Deprecated
    public boolean requireClientAuthentication = true;
    public boolean requireRegistration;

    @JacksonConstructor
    public OAuth2Configuration() {
    }

    public OAuth2Configuration(OAuth2Configuration other) {
        this.authorizedOriginURLs.addAll(other.authorizedOriginURLs);
        this.authorizedRedirectURLs.addAll(other.authorizedRedirectURLs);
        this.clientAuthenticationPolicy = other.clientAuthenticationPolicy;
        this.clientId = other.clientId;
        this.clientSecret = other.clientSecret;
        this.debug = other.debug;
        this.deviceVerificationURL = other.deviceVerificationURL;
        this.enabledGrants.addAll(other.enabledGrants);
        this.generateRefreshTokens = other.generateRefreshTokens;
        this.logoutBehavior = other.logoutBehavior;
        this.logoutURL = other.logoutURL;
        this.proofKeyForCodeExchangePolicy = other.proofKeyForCodeExchangePolicy;
        this.requireClientAuthentication = other.requireClientAuthentication;
        this.requireRegistration = other.requireRegistration;
    }

    public OAuth2Configuration(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Configuration)) {
            return false;
        }
        OAuth2Configuration that = (OAuth2Configuration)o;
        return this.debug == that.debug && this.generateRefreshTokens == that.generateRefreshTokens && this.requireClientAuthentication == that.requireClientAuthentication && this.requireRegistration == that.requireRegistration && Objects.equals(this.authorizedOriginURLs, that.authorizedOriginURLs) && Objects.equals(this.authorizedRedirectURLs, that.authorizedRedirectURLs) && Objects.equals((Object)this.clientAuthenticationPolicy, (Object)that.clientAuthenticationPolicy) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.deviceVerificationURL, that.deviceVerificationURL) && Objects.equals(this.enabledGrants, that.enabledGrants) && Objects.equals((Object)this.logoutBehavior, (Object)that.logoutBehavior) && Objects.equals(this.logoutURL, that.logoutURL) && Objects.equals((Object)this.proofKeyForCodeExchangePolicy, (Object)that.proofKeyForCodeExchangePolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizedOriginURLs, this.authorizedRedirectURLs, this.clientAuthenticationPolicy, this.clientId, this.clientSecret, this.debug, this.deviceVerificationURL, this.enabledGrants, this.generateRefreshTokens, this.logoutBehavior, this.logoutURL, this.proofKeyForCodeExchangePolicy, this.requireClientAuthentication, this.requireRegistration});
    }

    public void normalize() {
        Normalizer.removeEmpty(this.authorizedOriginURLs);
        Normalizer.removeEmpty(this.authorizedRedirectURLs);
        this.clientId = Normalizer.trim(this.clientId);
        this.clientSecret = Normalizer.trim(this.clientSecret);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

