/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.TwitterApplicationConfiguration;
import java.util.Objects;
import java.util.UUID;

public class TwitterIdentityProvider
extends BaseIdentityProvider<TwitterApplicationConfiguration>
implements Buildable<TwitterIdentityProvider> {
    @InternalJSONColumn
    public String buttonText = "Login with Twitter";
    @InternalJSONColumn
    public String consumerKey;
    @InternalJSONColumn
    public String consumerSecret;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TwitterIdentityProvider that = (TwitterIdentityProvider)o;
        return Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Twitter;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buttonText, this.consumerKey, this.consumerSecret);
    }

    public String lookupButtonText(UUID applicationId) {
        return this.lookup(() -> this.buttonText, () -> this.app(applicationId, (D app) -> app.buttonText));
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupConsumerKey(UUID applicationId) {
        return this.lookup(() -> this.consumerKey, () -> this.app(applicationId, (D app) -> app.consumerKey));
    }

    public String lookupConsumerKey(String clientId) {
        return this.lookup(() -> this.consumerKey, () -> this.app(clientId, (D app) -> app.consumerKey));
    }

    public String lookupConsumerSecret(UUID applicationId) {
        return this.lookup(() -> this.consumerSecret, () -> this.app(applicationId, (D app) -> app.consumerSecret));
    }

    public String lookupConsumerSecret(String clientId) {
        return this.lookup(() -> this.consumerSecret, () -> this.app(clientId, (D app) -> app.consumerSecret));
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

