/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.MissingNode;
import io.fusionauth.domain.api.MessageTemplateResponse;
import io.fusionauth.domain.message.MessageTemplate;
import io.fusionauth.domain.message.MessageType;
import io.fusionauth.json.MessageTemplateJacksonHelper;
import java.io.IOException;
import java.util.ArrayList;

public class MessageTemplateResponseDeserializer
extends StdDeserializer<MessageTemplateResponse> {
    public MessageTemplateResponseDeserializer() {
        super(MessageTemplateResponse.class);
    }

    public MessageTemplateResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new MessageTemplateResponse());
    }

    public MessageTemplateResponse deserialize(JsonParser p, DeserializationContext ctxt, MessageTemplateResponse resp) throws IOException {
        JsonNode messageTemplateNodes;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode messageTemplateNode = node.at("/messageTemplate");
        if (!messageTemplateNode.getClass().equals(MissingNode.class)) {
            MessageType messageType = MessageTemplateJacksonHelper.extractType(ctxt, p, messageTemplateNode);
            resp.messageTemplate = MessageTemplateJacksonHelper.newMessageTemplate(messageType);
            ((ObjectMapper)p.getCodec()).readerForUpdating((Object)resp.messageTemplate).readValue(messageTemplateNode);
        }
        if (!(messageTemplateNodes = node.at("/messageTemplates")).getClass().equals(MissingNode.class) && messageTemplateNodes.isArray()) {
            resp.messageTemplates = new ArrayList<MessageTemplate>();
            for (JsonNode messageTemplate : messageTemplateNodes) {
                MessageType messageType = MessageTemplateJacksonHelper.extractType(ctxt, p, messageTemplate);
                MessageTemplate baseMessageTemplate = MessageTemplateJacksonHelper.newMessageTemplate(messageType);
                ((ObjectMapper)p.getCodec()).readerForUpdating((Object)baseMessageTemplate).readValue(messageTemplate);
                resp.messageTemplates.add(baseMessageTemplate);
            }
        }
        return resp;
    }
}

