/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.domain.api.MessengerRequest;
import io.fusionauth.domain.messenger.MessengerType;
import io.fusionauth.json.MessengerJacksonHelper;
import java.io.IOException;

public class MessengerRequestDeserializer
extends StdDeserializer<MessengerRequest> {
    public MessengerRequestDeserializer() {
        super(MessengerRequest.class);
    }

    public MessengerRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new MessengerRequest());
    }

    public MessengerRequest deserialize(JsonParser p, DeserializationContext ctxt, MessengerRequest req) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode mNode = node.at("/messenger");
        if (req.messenger == null) {
            MessengerType mType = MessengerJacksonHelper.extractType(ctxt, p, mNode);
            req.messenger = MessengerJacksonHelper.newMessenger(mType);
        }
        ((ObjectMapper)p.getCodec()).readerForUpdating((Object)req.messenger).readValue(mNode);
        return req;
    }
}

