/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.ApplicationEvent;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;

public class JWTRefreshTokenRevokeEvent
extends BaseEvent
implements Buildable<JWTRefreshTokenRevokeEvent>,
ApplicationEvent {
    public UUID applicationId;
    public Map<UUID, Integer> applicationTimeToLiveInSeconds = new TreeMap<UUID, Integer>();
    public User user;
    public UUID userId;

    @JacksonConstructor
    public JWTRefreshTokenRevokeEvent() {
    }

    public JWTRefreshTokenRevokeEvent(EventInfo info, User user, UUID applicationId, int timeToLiveInSeconds) {
        super(info);
        this.applicationId = applicationId;
        this.applicationTimeToLiveInSeconds.put(applicationId, timeToLiveInSeconds);
        this.user = user;
        this.userId = user == null ? null : user.id;
    }

    public JWTRefreshTokenRevokeEvent(EventInfo info, User user, Map<UUID, Integer> applicationTimeToLiveInSeconds) {
        super(info);
        this.applicationTimeToLiveInSeconds.putAll(applicationTimeToLiveInSeconds);
        this.user = user;
        this.userId = user == null ? null : user.id;
    }

    public List<UUID> applicationIds() {
        return new ArrayList<UUID>(this.applicationTimeToLiveInSeconds.keySet());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JWTRefreshTokenRevokeEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JWTRefreshTokenRevokeEvent that = (JWTRefreshTokenRevokeEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.applicationTimeToLiveInSeconds, that.applicationTimeToLiveInSeconds) && Objects.equals(this.user, that.user) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public EventType getType() {
        return EventType.JWTRefreshTokenRevoke;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.applicationTimeToLiveInSeconds, this.user, this.userId);
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

