/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.EntityTypePermission;
import io.fusionauth.domain.internal._InternalJSONColumn;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class EntityType
implements Buildable<EntityType>,
_InternalJSONColumn {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public ZonedDateTime insertInstant;
    @InternalJSONColumn
    public EntityJWTConfiguration jwtConfiguration = new EntityJWTConfiguration();
    public ZonedDateTime lastUpdateInstant;
    public String name;
    public List<EntityTypePermission> permissions = new ArrayList<EntityTypePermission>();

    @JacksonConstructor
    public EntityType() {
    }

    public EntityType(String name) {
        this.name = name;
    }

    public EntityType(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityType)) {
            return false;
        }
        EntityType group = (EntityType)o;
        return Objects.equals(this.data, group.data) && Objects.equals(this.id, group.id) && Objects.equals(this.insertInstant, group.insertInstant) && Objects.equals(this.lastUpdateInstant, group.lastUpdateInstant) && Objects.equals(this.name, group.name) && Objects.equals(this.permissions, group.permissions);
    }

    public EntityTypePermission getPermission(String name) {
        for (EntityTypePermission permission : this.permissions) {
            if (!permission.name.equals(name)) continue;
            return permission;
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.id, this.insertInstant, this.lastUpdateInstant, this.name, this.permissions);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class EntityJWTConfiguration
    extends Enableable
    implements Buildable<EntityJWTConfiguration> {
        @ExcludeFromDatabaseDataColumn
        public UUID accessTokenKeyId;
        public int timeToLiveInSeconds;
    }
}

