/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.internal.annotation.ExcludeFromDatabaseDataColumn;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class TenantSCIMServerConfiguration
extends Enableable
implements Buildable<TenantSCIMServerConfiguration> {
    @ExcludeFromDatabaseDataColumn
    public UUID clientEntityTypeId;
    public Map<String, Object> schemas;
    @ExcludeFromDatabaseDataColumn
    public UUID serverEntityTypeId;

    @JacksonConstructor
    public TenantSCIMServerConfiguration() {
    }

    public TenantSCIMServerConfiguration(TenantSCIMServerConfiguration other) {
        this.clientEntityTypeId = other.clientEntityTypeId;
        this.enabled = other.enabled;
        this.schemas = other.schemas != null ? new LinkedHashMap<String, Object>(other.schemas) : null;
        this.serverEntityTypeId = other.serverEntityTypeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantSCIMServerConfiguration that = (TenantSCIMServerConfiguration)o;
        return Objects.equals(this.clientEntityTypeId, that.clientEntityTypeId) && Objects.equals(this.schemas, that.schemas) && Objects.equals(this.serverEntityTypeId, that.serverEntityTypeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientEntityTypeId, this.schemas, this.serverEntityTypeId);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

