/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.internal.annotation.InternalJSONColumn;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderLinkingStrategy;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.provider.NintendoApplicationConfiguration;
import io.fusionauth.domain.provider.SupportsPostBindings;
import java.util.Objects;
import java.util.UUID;

public class NintendoIdentityProvider
extends BaseIdentityProvider<NintendoApplicationConfiguration>
implements Buildable<NintendoIdentityProvider>,
SupportsPostBindings {
    @InternalJSONColumn
    public String buttonText = "Login with Nintendo";
    @InternalJSONColumn
    public String client_id;
    @InternalJSONColumn
    public String client_secret;
    @InternalJSONColumn
    public String emailClaim = "email";
    @InternalJSONColumn
    public String scope;
    @InternalJSONColumn
    public String uniqueIdClaim = "id";
    @InternalJSONColumn
    public String usernameClaim = "preferred_username";

    public NintendoIdentityProvider() {
        this.linkingStrategy = IdentityProviderLinkingStrategy.CreatePendingLink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NintendoIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NintendoIdentityProvider that = (NintendoIdentityProvider)o;
        return Objects.equals(this.buttonText, that.buttonText) && Objects.equals(this.client_id, that.client_id) && Objects.equals(this.client_secret, that.client_secret) && Objects.equals(this.emailClaim, that.emailClaim) && Objects.equals(this.scope, that.scope) && Objects.equals(this.uniqueIdClaim, that.uniqueIdClaim) && Objects.equals(this.usernameClaim, that.usernameClaim);
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.Nintendo;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buttonText, this.client_id, this.client_secret, this.emailClaim, this.scope, this.uniqueIdClaim, this.usernameClaim);
    }

    public String lookupButtonText(String clientId) {
        return this.lookup(() -> this.buttonText, () -> this.app(clientId, (D app) -> app.buttonText));
    }

    public String lookupClientId(UUID applicationId) {
        return this.lookup(() -> this.client_id, () -> this.app(applicationId, (D app) -> app.client_id));
    }

    public String lookupClientId(String clientId) {
        return this.lookup(() -> this.client_id, () -> this.app(clientId, (D app) -> app.client_id));
    }

    public String lookupClientSecret(UUID applicationId) {
        return this.lookup(() -> this.client_secret, () -> this.app(applicationId, (D app) -> app.client_secret));
    }

    public String lookupEmailClaim(UUID applicationId) {
        return this.lookup(() -> this.emailClaim, () -> this.app(this.emailClaim, (D app) -> app.emailClaim));
    }

    public String lookupScope(String clientId) {
        return this.lookup(() -> this.scope, () -> this.app(clientId, (D app) -> app.scope));
    }

    public String lookupUniqueIdClaim(UUID applicationId) {
        return this.lookup(() -> this.uniqueIdClaim, () -> this.app(this.uniqueIdClaim, (D app) -> app.uniqueIdClaim));
    }

    public String lookupUsernameClaim(UUID applicationId) {
        return this.lookup(() -> this.usernameClaim, () -> this.app(this.usernameClaim, (D app) -> app.usernameClaim));
    }

    @Override
    public boolean postRequestEnabled() {
        return false;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

