/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class LambdaDelegate {
    public final FusionAuthClient client;
    public final Consumer<ClientResponse<?, ?>> errorConsumer;
    public final Function<ClientResponse<?, ?>, ?> successFunction;

    public LambdaDelegate(FusionAuthClient client, Function<ClientResponse<?, ?>, ?> successFunction, Consumer<ClientResponse<?, ?>> errorConsumer) {
        Objects.requireNonNull(client, "You can't use the lambda delegate unless you supply a FusionAuthClient");
        Objects.requireNonNull(successFunction, "You can't use the lambda delegate unless you supply a success Function and error Consumer");
        Objects.requireNonNull(errorConsumer, "You can't use the lambda delegate unless you supply a success Function and error Consumer");
        this.client = client;
        this.errorConsumer = errorConsumer;
        this.successFunction = successFunction;
    }

    public <T, U> T execute(Function<FusionAuthClient, ClientResponse<T, U>> function) {
        ClientResponse<T, U> response = function.apply(this.client);
        if (response.wasSuccessful()) {
            return (T)this.successFunction.apply(response);
        }
        this.errorConsumer.accept(response);
        return null;
    }
}

