/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.ToString;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.event.EventType;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class BaseEvent {
    public List<UUID> applicationIds = new ArrayList<UUID>();
    public ZonedDateTime createInstant;
    public UUID id;
    public EventInfo info;
    public UUID tenantId;

    public BaseEvent() {
    }

    public BaseEvent(EventInfo info) {
        this.info = info;
    }

    public BaseEvent(EventInfo info, Set<UUID> applicationIds) {
        this.info = info;
        this.applicationIds = applicationIds.stream().collect(Collectors.toList());
    }

    public Collection<UUID> applicationIds() {
        return this.applicationIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEvent baseEvent = (BaseEvent)o;
        return Objects.equals(this.createInstant, baseEvent.createInstant) && Objects.equals(this.id, baseEvent.id) && Objects.equals(this.info, baseEvent.info) && Objects.equals(this.tenantId, baseEvent.tenantId);
    }

    public abstract EventType getType();

    public int hashCode() {
        return Objects.hash(this.createInstant, this.id, this.info, this.tenantId);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

