/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.email.Email;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.event.UserActionPhase;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class UserActionEvent
extends BaseEvent
implements Buildable<UserActionEvent> {
    public static ZonedDateTime Infinite = ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.MAX_VALUE), ZoneOffset.UTC);
    public String action;
    public UUID actionId;
    public UUID actioneeUserId;
    public UUID actionerUserId;
    public String comment;
    public Email email;
    public boolean emailedUser;
    public ZonedDateTime expiry;
    public String localizedAction;
    public String localizedDuration;
    public String localizedOption;
    public String localizedReason;
    public boolean notifyUser;
    public String option;
    public UserActionPhase phase;
    public String reason;
    public String reasonCode;

    @JacksonConstructor
    public UserActionEvent() {
    }

    public UserActionEvent(EventInfo info, UUID actionId, UUID actioneeUserId, UUID actionerUserId, List<UUID> applicationIds, String action, String localizedAction, String option, String localizedOption, String reason, String localizedReason, String reasonCode, ZonedDateTime expiry, String localizedDuration, UserActionPhase phase, String comment, boolean notifyUser, boolean emailedUser, Email email) {
        super(info);
        this.actionId = actionId;
        this.action = action;
        this.actioneeUserId = actioneeUserId;
        this.actionerUserId = actionerUserId;
        this.comment = comment;
        this.expiry = expiry;
        this.localizedAction = localizedAction;
        this.localizedDuration = localizedDuration;
        this.localizedOption = localizedOption;
        this.localizedReason = localizedReason;
        this.notifyUser = notifyUser;
        this.option = option;
        this.phase = phase;
        this.reason = reason;
        this.reasonCode = reasonCode;
        this.emailedUser = emailedUser;
        this.email = email;
        if (applicationIds != null) {
            this.applicationIds.addAll(applicationIds);
            Collections.sort(this.applicationIds);
        }
    }

    public boolean active() {
        return this.expiry != null && ZonedDateTime.now(ZoneOffset.UTC).isBefore(this.expiry);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserActionEvent)) {
            return false;
        }
        UserActionEvent that = (UserActionEvent)o;
        return super.equals(o) && Objects.equals(this.actionId, that.actionId) && Objects.equals(this.notifyUser, that.notifyUser) && Objects.equals(this.emailedUser, that.emailedUser) && Objects.equals(this.applicationIds, that.applicationIds) && Objects.equals(this.action, that.action) && Objects.equals(this.actioneeUserId, that.actioneeUserId) && Objects.equals(this.actionerUserId, that.actionerUserId) && Objects.equals(this.comment, that.comment) && Objects.equals(this.email, that.email) && Objects.equals(this.expiry, that.expiry) && Objects.equals(this.localizedAction, that.localizedAction) && Objects.equals(this.localizedDuration, that.localizedDuration) && Objects.equals(this.localizedOption, that.localizedOption) && Objects.equals(this.localizedReason, that.localizedReason) && Objects.equals(this.option, that.option) && Objects.equals((Object)this.phase, (Object)that.phase) && Objects.equals(this.reason, that.reason) && Objects.equals(this.reasonCode, that.reasonCode);
    }

    @Override
    public EventType getType() {
        return EventType.UserAction;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.actionId, this.applicationIds, this.action, this.actioneeUserId, this.actionerUserId, this.comment, this.email, this.expiry, this.localizedAction, this.localizedDuration, this.localizedOption, this.localizedReason, this.notifyUser, this.option, this.emailedUser, this.phase, this.reason, this.reasonCode});
    }

    @Override
    public String toString() {
        return ToString.toString((Object)this);
    }
}

