/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventRequest;
import io.fusionauth.domain.event.EventType;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class EventRequestDeserializer
extends StdDeserializer<EventRequest> {
    public EventRequestDeserializer() {
        super(EventRequest.class);
    }

    public EventRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new EventRequest());
    }

    public EventRequest deserialize(JsonParser p, DeserializationContext ctxt, EventRequest req) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode eventNode = node.at("/event");
        if (req.event == null) {
            EventType eventType = this.extractType(ctxt, p, eventNode);
            String className = BaseEvent.class.getPackage().getName() + "." + eventType.name() + "Event";
            try {
                req.event = (BaseEvent)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected type [" + (Object)((Object)eventType) + "]. This is a FusionAuth bug, could not instantiate class [" + className + "].");
            }
        }
        ((ObjectMapper)p.getCodec()).readerForUpdating((Object)req.event).readValue(eventNode);
        return req;
    }

    private EventType extractType(DeserializationContext ctxt, JsonParser p, JsonNode eventNode) throws IOException {
        JsonNode node = eventNode.at("/type");
        String type = node.asText();
        EventType eventType = EventType.forValue(type);
        if (eventType == null) {
            String sorted = Arrays.stream(EventType.values()).map(Enum::name).sorted().collect(Collectors.joining(", "));
            return (EventType)((Object)ctxt.handleUnexpectedToken(BaseEvent.class, node.asToken(), p, "Expected the type field to be one of [" + sorted + "], but found [" + node.asText() + "]", new Object[0]));
        }
        return eventType;
    }
}

