/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.MessengerJacksonHelper;
import io.fusionauth.domain.api.MessengerResponse;
import io.fusionauth.domain.messenger.BaseMessengerConfiguration;
import io.fusionauth.domain.messenger.MessengerType;
import java.io.IOException;
import java.util.ArrayList;

public class MessengerResponseDeserializer
extends StdDeserializer<MessengerResponse> {
    public MessengerResponseDeserializer() {
        super(MessengerResponse.class);
    }

    public MessengerResponse deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new MessengerResponse());
    }

    public MessengerResponse deserialize(JsonParser p, DeserializationContext ctxt, MessengerResponse resp) throws IOException {
        JsonNode messengerNodes;
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode messengerNode = node.at("/messenger");
        if (messengerNode != null) {
            MessengerType messengerType = MessengerJacksonHelper.extractType(ctxt, p, messengerNode);
            resp.messenger = MessengerJacksonHelper.newMessenger(messengerType);
            ((ObjectMapper)p.getCodec()).readerForUpdating((Object)resp.messenger).readValue(messengerNode);
        }
        if ((messengerNodes = node.at("/messengers")) != null && messengerNodes.isArray()) {
            resp.messengers = new ArrayList<BaseMessengerConfiguration>();
            for (JsonNode messenger : messengerNodes) {
                MessengerType messengerType = MessengerJacksonHelper.extractType(ctxt, p, messenger);
                BaseMessengerConfiguration baseMessengerConfiguration = MessengerJacksonHelper.newMessenger(messengerType);
                ((ObjectMapper)p.getCodec()).readerForUpdating((Object)baseMessengerConfiguration).readValue(messenger);
                resp.messengers.add(baseMessengerConfiguration);
            }
        }
        return resp;
    }
}

