/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CORSConfiguration;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.internal.annotation.InternalUse;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SystemConfiguration
implements Buildable<SystemConfiguration> {
    public AuditLogConfiguration auditLogConfiguration = new AuditLogConfiguration();
    @InternalUse
    public String cookieEncryptionKey;
    public CORSConfiguration corsConfiguration = new CORSConfiguration();
    public Map<String, Object> data = new HashMap<String, Object>();
    public EventLogConfiguration eventLogConfiguration = new EventLogConfiguration();
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public LoginRecordConfiguration loginRecordConfiguration = new LoginRecordConfiguration();
    public ZoneId reportTimezone;
    public UIConfiguration uiConfiguration = new UIConfiguration();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemConfiguration that = (SystemConfiguration)o;
        return Objects.equals(this.auditLogConfiguration, that.auditLogConfiguration) && Objects.equals(this.cookieEncryptionKey, that.cookieEncryptionKey) && Objects.equals(this.corsConfiguration, that.corsConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.eventLogConfiguration, that.eventLogConfiguration) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.loginRecordConfiguration, that.loginRecordConfiguration) && Objects.equals(this.reportTimezone, that.reportTimezone) && Objects.equals(this.uiConfiguration, that.uiConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.auditLogConfiguration, this.cookieEncryptionKey, this.corsConfiguration, this.data, this.eventLogConfiguration, this.insertInstant, this.lastUpdateInstant, this.loginRecordConfiguration, this.reportTimezone, this.uiConfiguration);
    }

    public void normalize() {
        if (this.uiConfiguration != null) {
            this.uiConfiguration.normalize();
        }
        if (this.corsConfiguration != null) {
            this.corsConfiguration.normalize();
        }
    }

    public SystemConfiguration secure() {
        this.cookieEncryptionKey = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class UIConfiguration
    implements Buildable<UIConfiguration> {
        public String headerColor;
        public String logoURL;
        public String menuFontColor;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UIConfiguration)) {
                return false;
            }
            UIConfiguration that = (UIConfiguration)o;
            return Objects.equals(this.logoURL, that.logoURL) && Objects.equals(this.headerColor, that.headerColor) && Objects.equals(this.menuFontColor, that.menuFontColor);
        }

        public int hashCode() {
            return Objects.hash(this.logoURL, this.headerColor, this.menuFontColor);
        }

        public void normalize() {
        }
    }

    public static class LoginRecordConfiguration {
        public DeleteConfiguration delete = new DeleteConfiguration(365);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoginRecordConfiguration)) {
                return false;
            }
            LoginRecordConfiguration that = (LoginRecordConfiguration)o;
            return Objects.equals(this.delete, that.delete);
        }

        public int hashCode() {
            return Objects.hash(this.delete);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class EventLogConfiguration {
        public int numberToRetain = 10000;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EventLogConfiguration)) {
                return false;
            }
            EventLogConfiguration that = (EventLogConfiguration)o;
            return this.numberToRetain == that.numberToRetain;
        }

        public int hashCode() {
            return Objects.hash(this.numberToRetain);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class DeleteConfiguration
    extends Enableable {
        public int numberOfDaysToRetain = 365;

        @JacksonConstructor
        public DeleteConfiguration() {
        }

        public DeleteConfiguration(int numberOfDaysToRetain) {
            this.numberOfDaysToRetain = numberOfDaysToRetain;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteConfiguration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DeleteConfiguration that = (DeleteConfiguration)o;
            return Objects.equals(this.numberOfDaysToRetain, that.numberOfDaysToRetain);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.numberOfDaysToRetain);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class AuditLogConfiguration {
        public DeleteConfiguration delete = new DeleteConfiguration(365);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AuditLogConfiguration)) {
                return false;
            }
            AuditLogConfiguration that = (AuditLogConfiguration)o;
            return Objects.equals(this.delete, that.delete);
        }

        public int hashCode() {
            return Objects.hash(this.delete);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

