/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EmailConfiguration;
import io.fusionauth.domain.EventConfiguration;
import io.fusionauth.domain.ExternalIdentifierConfiguration;
import io.fusionauth.domain.FailedAuthenticationConfiguration;
import io.fusionauth.domain.FamilyConfiguration;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.MaximumPasswordAge;
import io.fusionauth.domain.MinimumPasswordAge;
import io.fusionauth.domain.MultiFactorLoginPolicy;
import io.fusionauth.domain.ObjectState;
import io.fusionauth.domain.PasswordEncryptionConfiguration;
import io.fusionauth.domain.PasswordValidationRules;
import io.fusionauth.domain.TenantAccessControlConfiguration;
import io.fusionauth.domain.TenantCaptchaConfiguration;
import io.fusionauth.domain.TenantFormConfiguration;
import io.fusionauth.domain.TenantLambdaConfiguration;
import io.fusionauth.domain.TenantLoginConfiguration;
import io.fusionauth.domain.TenantMultiFactorConfiguration;
import io.fusionauth.domain.TenantRateLimitConfiguration;
import io.fusionauth.domain.TenantRegistrationConfiguration;
import io.fusionauth.domain.TenantSCIMServerConfiguration;
import io.fusionauth.domain.TenantSSOConfiguration;
import io.fusionauth.domain.TenantUserDeletePolicy;
import io.fusionauth.domain.TenantUsernameConfiguration;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.connector.ConnectorPolicy;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class Tenant
implements Buildable<Tenant> {
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public TenantAccessControlConfiguration accessControlConfiguration = new TenantAccessControlConfiguration();
    public TenantCaptchaConfiguration captchaConfiguration = new TenantCaptchaConfiguration();
    public boolean configured;
    public List<ConnectorPolicy> connectorPolicies = new ArrayList<ConnectorPolicy>();
    public EmailConfiguration emailConfiguration = new EmailConfiguration();
    public EventConfiguration eventConfiguration = new EventConfiguration();
    public ExternalIdentifierConfiguration externalIdentifierConfiguration = new ExternalIdentifierConfiguration();
    public FailedAuthenticationConfiguration failedAuthenticationConfiguration = new FailedAuthenticationConfiguration();
    public FamilyConfiguration familyConfiguration = new FamilyConfiguration();
    public TenantFormConfiguration formConfiguration = new TenantFormConfiguration();
    public int httpSessionMaxInactiveInterval = 3600;
    public UUID id;
    public ZonedDateTime insertInstant;
    public String issuer;
    @JsonIgnoreProperties(value={"enabled"})
    public JWTConfiguration jwtConfiguration = new JWTConfiguration();
    public TenantLambdaConfiguration lambdaConfiguration = new TenantLambdaConfiguration();
    public ZonedDateTime lastUpdateInstant;
    public TenantLoginConfiguration loginConfiguration = new TenantLoginConfiguration();
    public URI logoutURL;
    public MaximumPasswordAge maximumPasswordAge = new MaximumPasswordAge();
    public MinimumPasswordAge minimumPasswordAge = new MinimumPasswordAge();
    public TenantMultiFactorConfiguration multiFactorConfiguration = new TenantMultiFactorConfiguration();
    public String name;
    public TenantOAuth2Configuration oauthConfiguration = new TenantOAuth2Configuration();
    public PasswordEncryptionConfiguration passwordEncryptionConfiguration = new PasswordEncryptionConfiguration();
    public PasswordValidationRules passwordValidationRules = new PasswordValidationRules();
    public TenantRateLimitConfiguration rateLimitConfiguration = new TenantRateLimitConfiguration();
    public TenantRegistrationConfiguration registrationConfiguration = new TenantRegistrationConfiguration();
    public TenantSCIMServerConfiguration scimServerConfiguration = new TenantSCIMServerConfiguration();
    public TenantSSOConfiguration ssoConfiguration = new TenantSSOConfiguration();
    public ObjectState state;
    public UUID themeId;
    public TenantUserDeletePolicy userDeletePolicy = new TenantUserDeletePolicy();
    public TenantUsernameConfiguration usernameConfiguration = new TenantUsernameConfiguration();

    @JacksonConstructor
    public Tenant() {
    }

    public Tenant(Tenant other) {
        this.captchaConfiguration = new TenantCaptchaConfiguration(other.captchaConfiguration);
        this.configured = other.configured;
        this.connectorPolicies.addAll(other.connectorPolicies.stream().map(ConnectorPolicy::new).collect(Collectors.toList()));
        this.data.putAll(other.data);
        this.emailConfiguration = new EmailConfiguration(other.emailConfiguration);
        this.eventConfiguration = new EventConfiguration(other.eventConfiguration);
        this.externalIdentifierConfiguration = new ExternalIdentifierConfiguration(other.externalIdentifierConfiguration);
        this.failedAuthenticationConfiguration = new FailedAuthenticationConfiguration(other.failedAuthenticationConfiguration);
        this.familyConfiguration = new FamilyConfiguration(other.familyConfiguration);
        this.formConfiguration = new TenantFormConfiguration(other.formConfiguration);
        this.httpSessionMaxInactiveInterval = other.httpSessionMaxInactiveInterval;
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.accessControlConfiguration = new TenantAccessControlConfiguration(other.accessControlConfiguration);
        this.issuer = other.issuer;
        this.jwtConfiguration = new JWTConfiguration(other.jwtConfiguration);
        this.lambdaConfiguration = new TenantLambdaConfiguration(other.lambdaConfiguration);
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.loginConfiguration = new TenantLoginConfiguration(other.loginConfiguration);
        this.logoutURL = other.logoutURL;
        this.maximumPasswordAge = new MaximumPasswordAge(other.maximumPasswordAge);
        this.minimumPasswordAge = new MinimumPasswordAge(other.minimumPasswordAge);
        this.multiFactorConfiguration = new TenantMultiFactorConfiguration(other.multiFactorConfiguration);
        this.name = other.name;
        this.oauthConfiguration = new TenantOAuth2Configuration(other.oauthConfiguration);
        this.passwordEncryptionConfiguration = new PasswordEncryptionConfiguration(other.passwordEncryptionConfiguration);
        this.passwordValidationRules = new PasswordValidationRules(other.passwordValidationRules);
        this.rateLimitConfiguration = new TenantRateLimitConfiguration(other.rateLimitConfiguration);
        this.registrationConfiguration = new TenantRegistrationConfiguration(other.registrationConfiguration);
        this.scimServerConfiguration = new TenantSCIMServerConfiguration(other.scimServerConfiguration);
        this.ssoConfiguration = new TenantSSOConfiguration(other.ssoConfiguration);
        this.state = other.state;
        this.themeId = other.themeId;
        this.userDeletePolicy = new TenantUserDeletePolicy(other.userDeletePolicy);
        this.usernameConfiguration = new TenantUsernameConfiguration(other.usernameConfiguration);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant tenant = (Tenant)o;
        return this.configured == tenant.configured && this.httpSessionMaxInactiveInterval == tenant.httpSessionMaxInactiveInterval && Objects.equals(this.captchaConfiguration, tenant.captchaConfiguration) && Objects.equals(this.connectorPolicies, tenant.connectorPolicies) && Objects.equals(this.data, tenant.data) && Objects.equals(this.emailConfiguration, tenant.emailConfiguration) && Objects.equals(this.eventConfiguration, tenant.eventConfiguration) && Objects.equals(this.externalIdentifierConfiguration, tenant.externalIdentifierConfiguration) && Objects.equals(this.failedAuthenticationConfiguration, tenant.failedAuthenticationConfiguration) && Objects.equals(this.familyConfiguration, tenant.familyConfiguration) && Objects.equals(this.formConfiguration, tenant.formConfiguration) && Objects.equals(this.id, tenant.id) && Objects.equals(this.insertInstant, tenant.insertInstant) && Objects.equals(this.accessControlConfiguration, tenant.accessControlConfiguration) && Objects.equals(this.issuer, tenant.issuer) && Objects.equals(this.jwtConfiguration, tenant.jwtConfiguration) && Objects.equals(this.lambdaConfiguration, tenant.lambdaConfiguration) && Objects.equals(this.lastUpdateInstant, tenant.lastUpdateInstant) && Objects.equals(this.loginConfiguration, tenant.loginConfiguration) && Objects.equals(this.logoutURL, tenant.logoutURL) && Objects.equals(this.maximumPasswordAge, tenant.maximumPasswordAge) && Objects.equals(this.minimumPasswordAge, tenant.minimumPasswordAge) && Objects.equals(this.multiFactorConfiguration, tenant.multiFactorConfiguration) && Objects.equals(this.name, tenant.name) && Objects.equals(this.passwordEncryptionConfiguration, tenant.passwordEncryptionConfiguration) && Objects.equals(this.passwordValidationRules, tenant.passwordValidationRules) && Objects.equals(this.rateLimitConfiguration, tenant.rateLimitConfiguration) && Objects.equals(this.registrationConfiguration, tenant.registrationConfiguration) && Objects.equals(this.scimServerConfiguration, tenant.scimServerConfiguration) && Objects.equals(this.ssoConfiguration, tenant.ssoConfiguration) && Objects.equals((Object)this.state, (Object)tenant.state) && Objects.equals(this.themeId, tenant.themeId) && Objects.equals(this.userDeletePolicy, tenant.userDeletePolicy) && Objects.equals(this.usernameConfiguration, tenant.usernameConfiguration);
    }

    @JsonIgnore
    public ConnectorPolicy getPolicyByConnectorId(UUID connectorId) {
        return this.connectorPolicies.stream().filter(policy -> policy.connectorId.equals(connectorId)).findFirst().orElse(null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.captchaConfiguration, this.configured, this.connectorPolicies, this.data, this.emailConfiguration, this.eventConfiguration, this.externalIdentifierConfiguration, this.failedAuthenticationConfiguration, this.familyConfiguration, this.formConfiguration, this.httpSessionMaxInactiveInterval, this.id, this.insertInstant, this.accessControlConfiguration, this.issuer, this.jwtConfiguration, this.lambdaConfiguration, this.lastUpdateInstant, this.loginConfiguration, this.logoutURL, this.maximumPasswordAge, this.minimumPasswordAge, this.name, this.passwordEncryptionConfiguration, this.passwordValidationRules, this.rateLimitConfiguration, this.registrationConfiguration, this.scimServerConfiguration, this.state, this.themeId, this.userDeletePolicy, this.usernameConfiguration});
    }

    @JsonIgnore
    public JWTConfiguration lookupJWTConfiguration(Application application) {
        if (application != null && application.jwtConfiguration != null && application.jwtConfiguration.enabled) {
            return application.jwtConfiguration;
        }
        return this.jwtConfiguration;
    }

    @JsonIgnore
    public MultiFactorLoginPolicy lookupMultiFactorLoginPolicy(Application application) {
        if (application != null && application.multiFactorConfiguration.loginPolicy != null) {
            return application.multiFactorConfiguration.loginPolicy;
        }
        return this.multiFactorConfiguration.loginPolicy;
    }

    public void normalize() {
        if (!this.emailConfiguration.verifyEmail) {
            this.emailConfiguration.verifyEmailWhenChanged = false;
            this.emailConfiguration.verificationEmailTemplateId = null;
        }
        Normalizer.removeEmpty(this.data);
        this.name = Normalizer.trim(this.name);
        this.emailConfiguration.normalize();
        this.eventConfiguration.normalize();
        this.connectorPolicies.forEach(policy -> Normalizer.toLowerCase(policy.domains, HashSet::new));
        if (this.connectorPolicies.isEmpty()) {
            this.connectorPolicies.add(new ConnectorPolicy().with(cp -> {
                cp.connectorId = BaseConnectorConfiguration.FUSIONAUTH_CONNECTOR_ID;
            }).with(cp -> cp.domains.add("*")));
        } else {
            this.connectorPolicies.stream().filter(cp -> cp.connectorId.equals(BaseConnectorConfiguration.FUSIONAUTH_CONNECTOR_ID)).forEach(cp -> cp.with(cpInner -> cpInner.domains.clear()).with(cpInner -> cpInner.domains.add("*")).with(cpInner -> {
                cpInner.migrate = false;
            }));
        }
        this.familyConfiguration.normalize();
    }

    public Tenant secure() {
        this.emailConfiguration.password = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class TenantOAuth2Configuration {
        public UUID clientCredentialsAccessTokenPopulateLambdaId;

        public TenantOAuth2Configuration() {
        }

        public TenantOAuth2Configuration(TenantOAuth2Configuration other) {
            this.clientCredentialsAccessTokenPopulateLambdaId = other.clientCredentialsAccessTokenPopulateLambdaId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TenantOAuth2Configuration)) {
                return false;
            }
            TenantOAuth2Configuration that = (TenantOAuth2Configuration)o;
            return Objects.equals(this.clientCredentialsAccessTokenPopulateLambdaId, that.clientCredentialsAccessTokenPopulateLambdaId);
        }

        public int hashCode() {
            return Objects.hash(this.clientCredentialsAccessTokenPopulateLambdaId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

