/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.AuthenticatorConfiguration;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.MultiFactorLoginPolicy;
import java.util.Objects;
import java.util.UUID;

public class TenantMultiFactorConfiguration
implements Buildable<TenantMultiFactorConfiguration> {
    public MultiFactorAuthenticatorMethod authenticator = new MultiFactorAuthenticatorMethod().with(mfa -> {
        mfa.enabled = true;
    });
    public MultiFactorEmailMethod email = new MultiFactorEmailMethod();
    public MultiFactorLoginPolicy loginPolicy = MultiFactorLoginPolicy.Enabled;
    public MultiFactorSMSMethod sms = new MultiFactorSMSMethod();

    @JacksonConstructor
    public TenantMultiFactorConfiguration() {
    }

    public TenantMultiFactorConfiguration(TenantMultiFactorConfiguration other) {
        this.authenticator = new MultiFactorAuthenticatorMethod(other.authenticator);
        this.email = new MultiFactorEmailMethod(other.email);
        this.loginPolicy = other.loginPolicy;
        this.sms = new MultiFactorSMSMethod(other.sms);
    }

    @JsonIgnore
    public boolean anyEnabled() {
        return this.authenticator.enabled || this.sms.enabled || this.email.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantMultiFactorConfiguration that = (TenantMultiFactorConfiguration)o;
        return Objects.equals(this.authenticator, that.authenticator) && Objects.equals(this.email, that.email) && this.loginPolicy == that.loginPolicy && Objects.equals(this.sms, that.sms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticator, this.email, this.loginPolicy, this.sms});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class MultiFactorSMSMethod
    extends Enableable
    implements Buildable<MultiFactorSMSMethod> {
        public UUID messengerId;
        public UUID templateId;

        @JacksonConstructor
        public MultiFactorSMSMethod() {
        }

        public MultiFactorSMSMethod(MultiFactorSMSMethod other) {
            this.enabled = other.enabled;
            this.messengerId = other.messengerId;
            this.templateId = other.templateId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MultiFactorSMSMethod that = (MultiFactorSMSMethod)o;
            return Objects.equals(this.messengerId, that.messengerId) && Objects.equals(this.templateId, that.templateId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.messengerId, this.templateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class MultiFactorEmailMethod
    extends Enableable
    implements Buildable<MultiFactorEmailMethod> {
        public UUID templateId;

        @JacksonConstructor
        public MultiFactorEmailMethod() {
        }

        public MultiFactorEmailMethod(MultiFactorEmailMethod other) {
            this.enabled = other.enabled;
            this.templateId = other.templateId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MultiFactorEmailMethod that = (MultiFactorEmailMethod)o;
            return Objects.equals(this.templateId, that.templateId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.templateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class MultiFactorAuthenticatorMethod
    extends Enableable
    implements Buildable<MultiFactorAuthenticatorMethod> {
        public AuthenticatorConfiguration.TOTPAlgorithm algorithm = AuthenticatorConfiguration.TOTPAlgorithm.HmacSHA1;
        public int codeLength = 6;
        public int timeStep = 30;

        @JacksonConstructor
        public MultiFactorAuthenticatorMethod() {
        }

        public MultiFactorAuthenticatorMethod(MultiFactorAuthenticatorMethod other) {
            this.algorithm = other.algorithm;
            this.codeLength = other.codeLength;
            this.enabled = other.enabled;
            this.timeStep = other.timeStep;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MultiFactorAuthenticatorMethod that = (MultiFactorAuthenticatorMethod)o;
            return this.codeLength == that.codeLength && this.timeStep == that.timeStep && this.algorithm == that.algorithm;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.algorithm, this.codeLength, this.timeStep});
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

