/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.email;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class EmailTemplate
implements Buildable<EmailTemplate> {
    public String defaultFromName;
    public String defaultHtmlTemplate;
    public String defaultSubject;
    public String defaultTextTemplate;
    public String fromEmail;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public LocalizedStrings localizedFromNames = new LocalizedStrings();
    public LocalizedStrings localizedHtmlTemplates = new LocalizedStrings();
    public LocalizedStrings localizedSubjects = new LocalizedStrings();
    public LocalizedStrings localizedTextTemplates = new LocalizedStrings();
    public String name;

    @JacksonConstructor
    public EmailTemplate() {
    }

    public EmailTemplate(UUID id, String name, String defaultFromName, String fromEmail, String defaultSubject, String defaultHtmlTemplate, String defaultTextTemplate) {
        this.defaultFromName = defaultFromName;
        this.fromEmail = fromEmail;
        this.defaultHtmlTemplate = defaultHtmlTemplate;
        this.defaultSubject = defaultSubject;
        this.defaultTextTemplate = defaultTextTemplate;
        this.id = id;
        this.name = name;
    }

    public EmailTemplate(UUID id, String name, String defaultFromName, String fromEmail, String defaultSubject, String defaultHtmlTemplate, String defaultTextTemplate, LocalizedStrings localizedFromNames, LocalizedStrings localizedSubjects, LocalizedStrings localizedHtmlTemplates, LocalizedStrings localizedTextTemplates) {
        this.fromEmail = fromEmail;
        this.defaultFromName = defaultFromName;
        this.defaultHtmlTemplate = defaultHtmlTemplate;
        this.defaultSubject = defaultSubject;
        this.defaultTextTemplate = defaultTextTemplate;
        this.id = id;
        this.localizedFromNames = localizedFromNames;
        this.localizedHtmlTemplates = localizedHtmlTemplates;
        this.localizedSubjects = localizedSubjects;
        this.localizedTextTemplates = localizedTextTemplates;
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailTemplate)) {
            return false;
        }
        EmailTemplate that = (EmailTemplate)o;
        return Objects.equals(this.defaultFromName, that.defaultFromName) && Objects.equals(this.defaultHtmlTemplate, that.defaultHtmlTemplate) && Objects.equals(this.defaultSubject, that.defaultSubject) && Objects.equals(this.defaultTextTemplate, that.defaultTextTemplate) && Objects.equals(this.fromEmail, that.fromEmail) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.localizedFromNames, that.localizedFromNames) && Objects.equals(this.localizedHtmlTemplates, that.localizedHtmlTemplates) && Objects.equals(this.localizedSubjects, that.localizedSubjects) && Objects.equals(this.localizedTextTemplates, that.localizedTextTemplates) && Objects.equals(this.name, that.name);
    }

    @JsonIgnore
    public Set<Locale> getLocalizations() {
        HashSet<Locale> locales = new HashSet<Locale>(this.localizedFromNames.keySet());
        locales.addAll(this.localizedHtmlTemplates.keySet());
        locales.addAll(this.localizedSubjects.keySet());
        locales.addAll(this.localizedTextTemplates.keySet());
        return locales;
    }

    public int hashCode() {
        return Objects.hash(this.defaultFromName, this.defaultHtmlTemplate, this.defaultSubject, this.defaultTextTemplate, this.fromEmail, this.id, this.insertInstant, this.lastUpdateInstant, this.localizedFromNames, this.localizedHtmlTemplates, this.localizedSubjects, this.localizedTextTemplates, this.name);
    }

    public void normalize() {
        this.defaultFromName = Normalizer.trim(this.defaultFromName);
        this.defaultHtmlTemplate = Normalizer.trim(this.defaultHtmlTemplate);
        this.defaultSubject = Normalizer.trim(this.defaultSubject);
        this.defaultTextTemplate = Normalizer.trim(this.defaultTextTemplate);
        this.fromEmail = Normalizer.trim(this.fromEmail);
        this.name = Normalizer.trim(this.name);
        if (this.localizedFromNames != null) {
            this.localizedFromNames.normalize();
        }
        if (this.localizedHtmlTemplates != null) {
            this.localizedHtmlTemplates.normalize();
        }
        if (this.localizedSubjects != null) {
            this.localizedSubjects.normalize();
        }
        if (this.localizedTextTemplates != null) {
            this.localizedTextTemplates.normalize();
        }
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

