/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.jwt;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import java.time.ZonedDateTime;
import java.util.Objects;

public class DeviceInfo
implements Buildable<DeviceInfo> {
    public String description;
    public String lastAccessedAddress;
    public ZonedDateTime lastAccessedInstant;
    public String name;
    public DeviceType type = DeviceType.UNKNOWN;

    @JacksonConstructor
    public DeviceInfo() {
    }

    public DeviceInfo(DeviceInfo other) {
        this.description = other.description;
        this.lastAccessedAddress = other.lastAccessedAddress;
        this.lastAccessedInstant = other.lastAccessedInstant;
        this.name = other.name;
        this.type = other.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceInfo device = (DeviceInfo)o;
        return Objects.equals(this.description, device.description) && Objects.equals(this.lastAccessedAddress, device.lastAccessedAddress) && Objects.equals(this.lastAccessedInstant, device.lastAccessedInstant) && Objects.equals(this.name, device.name) && this.type == device.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.lastAccessedAddress, this.lastAccessedInstant, this.name, this.type});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static enum DeviceType {
        BROWSER,
        DESKTOP,
        LAPTOP,
        MOBILE,
        OTHER,
        SERVER,
        TABLET,
        TV,
        UNKNOWN;


        public static DeviceType safeValueOf(String type) {
            if (type == null) {
                return null;
            }
            try {
                return DeviceType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

