/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.util.Map;
import java.util.regex.Pattern;

public class SQLTools {
    private static final Pattern EmptySpace = Pattern.compile("\\s{2,}");
    private static final Pattern ValidOrderBy = Pattern.compile("(([a-z0-9_]+|`[a-z0-9_]+`)(\\s+(asc|desc))?\\s*(,\\s*(?=[a-z0-9_`])|$))+", 2);

    public static String normalizeOrderBy(String orderBy, Map<String, String> sortableFields) {
        for (String field : sortableFields.keySet()) {
            orderBy = orderBy.replace(field, sortableFields.get(field));
        }
        return orderBy;
    }

    public static String sanitizeOrderBy(String orderBy) {
        if (orderBy == null) {
            return null;
        }
        String normalized = EmptySpace.matcher(orderBy).replaceAll(" ").trim();
        if (ValidOrderBy.matcher(normalized).matches()) {
            return orderBy;
        }
        return null;
    }

    public static String toSearchString(String s) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(42);
        if (index == -1) {
            return "%" + s.trim().toLowerCase() + "%";
        }
        StringBuilder sb = new StringBuilder();
        s = s.trim().toLowerCase();
        for (index = 0; index < s.length(); ++index) {
            if (s.charAt(index) == '*') {
                if (index < s.length() - 1 && s.charAt(index + 1) == '*') {
                    sb.append(s.charAt(index));
                    ++index;
                    continue;
                }
                sb.append('%');
                continue;
            }
            sb.append(s.charAt(index));
        }
        return sb.toString();
    }
}

