/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EmailHeader;
import io.fusionauth.domain.EmailUnverifiedOptions;
import io.fusionauth.domain.VerificationStrategy;
import io.fusionauth.domain.util.Normalizer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class EmailConfiguration
implements Buildable<EmailConfiguration> {
    @JsonIgnore
    public static List<String> EmailTemplateIdFieldNames = Arrays.stream(EmailConfiguration.class.getDeclaredFields()).map(Field::getName).filter(name -> name.endsWith("EmailTemplateId")).sorted().collect(Collectors.toList());
    @JsonIgnore
    public static List<Field> EmailTemplateIdFields = Arrays.stream(EmailConfiguration.class.getDeclaredFields()).filter(f -> f.getName().endsWith("EmailTemplateId")).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
    public List<EmailHeader> additionalHeaders = new ArrayList<EmailHeader>();
    public boolean debug;
    public String defaultFromEmail = "change-me@example.com";
    public String defaultFromName;
    public UUID emailUpdateEmailTemplateId;
    public UUID emailVerifiedEmailTemplateId;
    public UUID forgotPasswordEmailTemplateId;
    public String host = "localhost";
    public boolean implicitEmailVerificationAllowed = true;
    public UUID loginIdInUseOnCreateEmailTemplateId;
    public UUID loginIdInUseOnUpdateEmailTemplateId;
    public UUID loginNewDeviceEmailTemplateId;
    public UUID loginSuspiciousEmailTemplateId;
    public String password;
    public UUID passwordResetSuccessEmailTemplateId;
    public UUID passwordUpdateEmailTemplateId;
    public UUID passwordlessEmailTemplateId;
    public Integer port = 25;
    public String properties;
    public EmailSecurityType security;
    public UUID setPasswordEmailTemplateId;
    public UUID twoFactorMethodAddEmailTemplateId;
    public UUID twoFactorMethodRemoveEmailTemplateId;
    public EmailUnverifiedOptions unverified = new EmailUnverifiedOptions();
    public String username;
    public UUID verificationEmailTemplateId;
    public VerificationStrategy verificationStrategy;
    public boolean verifyEmail;
    public boolean verifyEmailWhenChanged;

    @JacksonConstructor
    public EmailConfiguration() {
    }

    public EmailConfiguration(EmailConfiguration other) {
        this.additionalHeaders.addAll(other.additionalHeaders);
        this.debug = other.debug;
        this.defaultFromEmail = other.defaultFromEmail;
        this.defaultFromName = other.defaultFromName;
        this.emailUpdateEmailTemplateId = other.emailUpdateEmailTemplateId;
        this.emailVerifiedEmailTemplateId = other.emailVerifiedEmailTemplateId;
        this.forgotPasswordEmailTemplateId = other.forgotPasswordEmailTemplateId;
        this.host = other.host;
        this.implicitEmailVerificationAllowed = other.implicitEmailVerificationAllowed;
        this.loginNewDeviceEmailTemplateId = other.loginNewDeviceEmailTemplateId;
        this.loginSuspiciousEmailTemplateId = other.loginSuspiciousEmailTemplateId;
        this.password = other.password;
        this.passwordlessEmailTemplateId = other.passwordlessEmailTemplateId;
        this.passwordResetSuccessEmailTemplateId = other.passwordResetSuccessEmailTemplateId;
        this.passwordUpdateEmailTemplateId = other.passwordUpdateEmailTemplateId;
        this.port = other.port;
        this.properties = other.properties;
        this.security = other.security;
        this.setPasswordEmailTemplateId = other.setPasswordEmailTemplateId;
        this.twoFactorMethodAddEmailTemplateId = other.twoFactorMethodAddEmailTemplateId;
        this.twoFactorMethodRemoveEmailTemplateId = other.twoFactorMethodRemoveEmailTemplateId;
        this.unverified = new EmailUnverifiedOptions(other.unverified);
        this.username = other.username;
        this.loginIdInUseOnCreateEmailTemplateId = other.loginIdInUseOnCreateEmailTemplateId;
        this.loginIdInUseOnUpdateEmailTemplateId = other.loginIdInUseOnUpdateEmailTemplateId;
        this.verificationEmailTemplateId = other.verificationEmailTemplateId;
        this.verificationStrategy = other.verificationStrategy;
        this.verifyEmail = other.verifyEmail;
        this.verifyEmailWhenChanged = other.verifyEmailWhenChanged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailConfiguration that = (EmailConfiguration)o;
        return this.implicitEmailVerificationAllowed == that.implicitEmailVerificationAllowed && this.verifyEmail == that.verifyEmail && this.verifyEmailWhenChanged == that.verifyEmailWhenChanged && Objects.equals(this.additionalHeaders, that.additionalHeaders) && Objects.equals(this.debug, that.debug) && Objects.equals(this.defaultFromEmail, that.defaultFromEmail) && Objects.equals(this.defaultFromName, that.defaultFromName) && Objects.equals(this.emailUpdateEmailTemplateId, that.emailUpdateEmailTemplateId) && Objects.equals(this.emailVerifiedEmailTemplateId, that.emailVerifiedEmailTemplateId) && Objects.equals(this.forgotPasswordEmailTemplateId, that.forgotPasswordEmailTemplateId) && Objects.equals(this.host, that.host) && Objects.equals(this.loginIdInUseOnCreateEmailTemplateId, that.loginIdInUseOnCreateEmailTemplateId) && Objects.equals(this.loginIdInUseOnUpdateEmailTemplateId, that.loginIdInUseOnUpdateEmailTemplateId) && Objects.equals(this.loginNewDeviceEmailTemplateId, that.loginNewDeviceEmailTemplateId) && Objects.equals(this.loginSuspiciousEmailTemplateId, that.loginSuspiciousEmailTemplateId) && Objects.equals(this.password, that.password) && Objects.equals(this.passwordResetSuccessEmailTemplateId, that.passwordResetSuccessEmailTemplateId) && Objects.equals(this.passwordUpdateEmailTemplateId, that.passwordUpdateEmailTemplateId) && Objects.equals(this.passwordlessEmailTemplateId, that.passwordlessEmailTemplateId) && Objects.equals(this.port, that.port) && Objects.equals(this.properties, that.properties) && this.security == that.security && Objects.equals(this.setPasswordEmailTemplateId, that.setPasswordEmailTemplateId) && Objects.equals(this.twoFactorMethodAddEmailTemplateId, that.twoFactorMethodAddEmailTemplateId) && Objects.equals(this.twoFactorMethodRemoveEmailTemplateId, that.twoFactorMethodRemoveEmailTemplateId) && Objects.equals(this.unverified, that.unverified) && Objects.equals(this.username, that.username) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId) && this.verificationStrategy == that.verificationStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalHeaders, this.debug, this.defaultFromEmail, this.defaultFromName, this.emailUpdateEmailTemplateId, this.emailVerifiedEmailTemplateId, this.forgotPasswordEmailTemplateId, this.host, this.implicitEmailVerificationAllowed, this.loginIdInUseOnCreateEmailTemplateId, this.loginIdInUseOnUpdateEmailTemplateId, this.loginNewDeviceEmailTemplateId, this.loginSuspiciousEmailTemplateId, this.password, this.passwordResetSuccessEmailTemplateId, this.passwordUpdateEmailTemplateId, this.passwordlessEmailTemplateId, this.port, this.properties, this.security, this.setPasswordEmailTemplateId, this.twoFactorMethodAddEmailTemplateId, this.twoFactorMethodRemoveEmailTemplateId, this.unverified, this.username, this.verificationEmailTemplateId, this.verificationStrategy, this.verifyEmail, this.verifyEmailWhenChanged});
    }

    public void normalize() {
        this.host = Normalizer.trim(this.host);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static enum EmailSecurityType {
        NONE,
        SSL,
        TLS;

    }
}

