/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.LocalizedStrings;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Stream;

public class Theme
implements Buildable<Theme> {
    public static final UUID FUSIONAUTH_THEME_ID = UUID.fromString("75a068fd-e94b-451a-9aeb-3ddb9a3b5987");
    public Map<String, Object> data = new HashMap<String, Object>();
    public String defaultMessages;
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public LocalizedStrings localizedMessages = new LocalizedStrings();
    public String name;
    public String stylesheet;
    public Templates templates;

    public Theme() {
    }

    public Theme(Theme theme) {
        this.data.putAll(theme.data);
        this.defaultMessages = theme.defaultMessages;
        this.id = theme.id;
        this.insertInstant = theme.insertInstant;
        this.lastUpdateInstant = theme.lastUpdateInstant;
        this.localizedMessages.putAll(theme.localizedMessages);
        this.name = theme.name;
        this.stylesheet = theme.stylesheet;
        if (theme.templates != null) {
            this.templates = new Templates(theme.templates);
        }
    }

    public Set<Locale> additionalLocales() {
        return Collections.emptySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Theme)) {
            return false;
        }
        Theme that = (Theme)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.defaultMessages, that.defaultMessages) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.localizedMessages, that.localizedMessages) && Objects.equals(this.name, that.name) && Objects.equals(this.stylesheet, that.stylesheet) && Objects.equals(this.templates, that.templates);
    }

    public String formatZoneDateTime(ZonedDateTime zonedDateTime, String format) {
        return zonedDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    public String formatZoneDateTime(ZonedDateTime zonedDateTime, String format, ZoneId zoneId) {
        return zonedDateTime.withZoneSameInstant(zoneId).format(DateTimeFormatter.ofPattern(format));
    }

    public int hashCode() {
        return Objects.hash(this.data, this.defaultMessages, this.id, this.insertInstant, this.lastUpdateInstant, this.localizedMessages, this.name, this.stylesheet, this.templates);
    }

    public String message(String key, Object ... arguments) {
        return "";
    }

    @JsonIgnore
    public boolean missingTemplate() {
        if (this.templates == null) {
            return true;
        }
        return Stream.of(this.templates.accountEdit, this.templates.accountIndex, this.templates.accountTwoFactorDisable, this.templates.accountTwoFactorEnable, this.templates.accountTwoFactorIndex, this.templates.accountWebAuthnAdd, this.templates.accountWebAuthnDelete, this.templates.accountWebAuthnIndex, this.templates.emailComplete, this.templates.emailSent, this.templates.emailVerificationRequired, this.templates.emailVerify, this.templates.helpers, this.templates.index, this.templates.oauth2Authorize, this.templates.oauth2AuthorizedNotRegistered, this.templates.oauth2ChildRegistrationNotAllowed, this.templates.oauth2ChildRegistrationNotAllowedComplete, this.templates.oauth2CompleteRegistration, this.templates.oauth2Device, this.templates.oauth2DeviceComplete, this.templates.oauth2Error, this.templates.oauth2Logout, this.templates.oauth2Passwordless, this.templates.oauth2Register, this.templates.oauth2StartIdPLink, this.templates.oauth2TwoFactor, this.templates.oauth2TwoFactorMethods, this.templates.oauth2Wait, this.templates.oauth2WebAuthn, this.templates.oauth2WebAuthnReauth, this.templates.oauth2WebAuthnReauthEnable, this.templates.passwordChange, this.templates.passwordComplete, this.templates.passwordForgot, this.templates.passwordSent, this.templates.registrationComplete, this.templates.registrationSent, this.templates.registrationVerificationRequired, this.templates.registrationVerify, this.templates.samlv2Logout, this.templates.unauthorized).anyMatch(Objects::isNull);
    }

    public void normalize() {
        if (this.defaultMessages != null) {
            this.defaultMessages = Normalizer.lineReturns(this.defaultMessages);
        }
        if (this.templates != null) {
            this.templates.normalize();
        }
        if (this.localizedMessages != null) {
            this.localizedMessages.normalize();
        }
        this.stylesheet = Normalizer.lineReturns(this.stylesheet);
    }

    public String optionalMessage(String key, Object ... arguments) {
        return "";
    }

    public String stylesheet() {
        if (this.stylesheet == null) {
            return "";
        }
        return Normalizer.lineReturns(this.stylesheet);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class Templates
    implements Buildable<Templates> {
        public static final SortedSet<String> Names = Collections.unmodifiableSortedSet(new TreeSet<String>(Arrays.asList("accountEdit", "accountIndex", "accountTwoFactorDisable", "accountTwoFactorEnable", "accountTwoFactorIndex", "accountWebAuthnAdd", "accountWebAuthnDelete", "accountWebAuthnIndex", "emailComplete", "emailSent", "emailVerificationRequired", "emailVerify", "helpers", "index", "oauth2Authorize", "oauth2AuthorizedNotRegistered", "oauth2ChildRegistrationNotAllowed", "oauth2ChildRegistrationNotAllowedComplete", "oauth2CompleteRegistration", "oauth2Device", "oauth2DeviceComplete", "oauth2Error", "oauth2Logout", "oauth2Passwordless", "oauth2Register", "oauth2StartIdPLink", "oauth2TwoFactor", "oauth2TwoFactorMethods", "oauth2Wait", "oauth2WebAuthn", "oauth2WebAuthnReauth", "oauth2WebAuthnReauthEnable", "passwordChange", "passwordComplete", "passwordForgot", "passwordSent", "registrationComplete", "registrationSent", "registrationVerificationRequired", "registrationVerify", "samlv2Logout", "unauthorized")));
        public String accountEdit;
        public String accountIndex;
        public String accountTwoFactorDisable;
        public String accountTwoFactorEnable;
        public String accountTwoFactorIndex;
        public String accountWebAuthnAdd;
        public String accountWebAuthnDelete;
        public String accountWebAuthnIndex;
        public String emailComplete;
        public String emailSent;
        public String emailVerificationRequired;
        public String emailVerify;
        public String helpers;
        public String index;
        public String oauth2Authorize;
        public String oauth2AuthorizedNotRegistered;
        public String oauth2ChildRegistrationNotAllowed;
        public String oauth2ChildRegistrationNotAllowedComplete;
        public String oauth2CompleteRegistration;
        public String oauth2Device;
        public String oauth2DeviceComplete;
        public String oauth2Error;
        public String oauth2Logout;
        public String oauth2Passwordless;
        public String oauth2Register;
        public String oauth2StartIdPLink;
        public String oauth2TwoFactor;
        public String oauth2TwoFactorMethods;
        public String oauth2Wait;
        public String oauth2WebAuthn;
        public String oauth2WebAuthnReauth;
        public String oauth2WebAuthnReauthEnable;
        public String passwordChange;
        public String passwordComplete;
        public String passwordForgot;
        public String passwordSent;
        public String registrationComplete;
        public String registrationSent;
        public String registrationVerificationRequired;
        public String registrationVerify;
        public String samlv2Logout;
        public String unauthorized;

        public Templates() {
        }

        public Templates(Templates other) {
            this.accountEdit = other.accountEdit;
            this.accountIndex = other.accountIndex;
            this.accountTwoFactorDisable = other.accountTwoFactorDisable;
            this.accountTwoFactorEnable = other.accountTwoFactorEnable;
            this.accountTwoFactorIndex = other.accountTwoFactorIndex;
            this.accountWebAuthnAdd = other.accountWebAuthnAdd;
            this.accountWebAuthnDelete = other.accountWebAuthnDelete;
            this.accountWebAuthnIndex = other.accountWebAuthnIndex;
            this.emailComplete = other.emailComplete;
            this.emailSent = other.emailSent;
            this.emailVerificationRequired = other.emailVerificationRequired;
            this.emailVerify = other.emailVerify;
            this.helpers = other.helpers;
            this.index = other.index;
            this.oauth2Authorize = other.oauth2Authorize;
            this.oauth2AuthorizedNotRegistered = other.oauth2AuthorizedNotRegistered;
            this.oauth2ChildRegistrationNotAllowed = other.oauth2ChildRegistrationNotAllowed;
            this.oauth2ChildRegistrationNotAllowedComplete = other.oauth2ChildRegistrationNotAllowedComplete;
            this.oauth2CompleteRegistration = other.oauth2CompleteRegistration;
            this.oauth2Device = other.oauth2Device;
            this.oauth2DeviceComplete = other.oauth2DeviceComplete;
            this.oauth2Error = other.oauth2Error;
            this.oauth2Logout = other.oauth2Logout;
            this.oauth2Passwordless = other.oauth2Passwordless;
            this.oauth2Register = other.oauth2Register;
            this.oauth2StartIdPLink = other.oauth2StartIdPLink;
            this.oauth2TwoFactor = other.oauth2TwoFactor;
            this.oauth2TwoFactorMethods = other.oauth2TwoFactorMethods;
            this.oauth2Wait = other.oauth2Wait;
            this.oauth2WebAuthn = other.oauth2WebAuthn;
            this.oauth2WebAuthnReauth = other.oauth2WebAuthnReauth;
            this.oauth2WebAuthnReauthEnable = other.oauth2WebAuthnReauthEnable;
            this.passwordChange = other.passwordChange;
            this.passwordComplete = other.passwordComplete;
            this.passwordForgot = other.passwordForgot;
            this.passwordSent = other.passwordSent;
            this.registrationComplete = other.registrationComplete;
            this.registrationSent = other.registrationSent;
            this.registrationVerificationRequired = other.registrationVerificationRequired;
            this.registrationVerify = other.registrationVerify;
            this.samlv2Logout = other.samlv2Logout;
            this.unauthorized = other.unauthorized;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Templates that = (Templates)o;
            return Objects.equals(this.accountEdit, that.accountEdit) && Objects.equals(this.accountIndex, that.accountIndex) && Objects.equals(this.accountTwoFactorDisable, that.accountTwoFactorDisable) && Objects.equals(this.accountTwoFactorEnable, that.accountTwoFactorEnable) && Objects.equals(this.accountTwoFactorIndex, that.accountTwoFactorIndex) && Objects.equals(this.accountWebAuthnAdd, that.accountWebAuthnAdd) && Objects.equals(this.accountWebAuthnDelete, that.accountWebAuthnDelete) && Objects.equals(this.accountWebAuthnIndex, that.accountWebAuthnIndex) && Objects.equals(this.emailComplete, that.emailComplete) && Objects.equals(this.emailSent, that.emailSent) && Objects.equals(this.emailVerificationRequired, that.emailVerificationRequired) && Objects.equals(this.emailVerify, that.emailVerify) && Objects.equals(this.helpers, that.helpers) && Objects.equals(this.index, that.index) && Objects.equals(this.oauth2Authorize, that.oauth2Authorize) && Objects.equals(this.oauth2AuthorizedNotRegistered, that.oauth2AuthorizedNotRegistered) && Objects.equals(this.oauth2ChildRegistrationNotAllowed, that.oauth2ChildRegistrationNotAllowed) && Objects.equals(this.oauth2ChildRegistrationNotAllowedComplete, that.oauth2ChildRegistrationNotAllowedComplete) && Objects.equals(this.oauth2CompleteRegistration, that.oauth2CompleteRegistration) && Objects.equals(this.oauth2Device, that.oauth2Device) && Objects.equals(this.oauth2DeviceComplete, that.oauth2DeviceComplete) && Objects.equals(this.oauth2Error, that.oauth2Error) && Objects.equals(this.oauth2Logout, that.oauth2Logout) && Objects.equals(this.oauth2Passwordless, that.oauth2Passwordless) && Objects.equals(this.oauth2Register, that.oauth2Register) && Objects.equals(this.oauth2StartIdPLink, that.oauth2StartIdPLink) && Objects.equals(this.oauth2TwoFactor, that.oauth2TwoFactor) && Objects.equals(this.oauth2TwoFactorMethods, that.oauth2TwoFactorMethods) && Objects.equals(this.oauth2Wait, that.oauth2Wait) && Objects.equals(this.oauth2WebAuthn, that.oauth2WebAuthn) && Objects.equals(this.oauth2WebAuthnReauth, that.oauth2WebAuthnReauth) && Objects.equals(this.oauth2WebAuthnReauthEnable, that.oauth2WebAuthnReauthEnable) && Objects.equals(this.passwordChange, that.passwordChange) && Objects.equals(this.passwordComplete, that.passwordComplete) && Objects.equals(this.passwordForgot, that.passwordForgot) && Objects.equals(this.passwordSent, that.passwordSent) && Objects.equals(this.registrationComplete, that.registrationComplete) && Objects.equals(this.registrationSent, that.registrationSent) && Objects.equals(this.registrationVerificationRequired, that.registrationVerificationRequired) && Objects.equals(this.registrationVerify, that.registrationVerify) && Objects.equals(this.samlv2Logout, that.samlv2Logout) && Objects.equals(this.unauthorized, that.unauthorized);
        }

        @Deprecated
        public String getEmailSend() {
            return this.emailSent;
        }

        @Deprecated
        public void setEmailSend(String emailSend) {
            this.emailSent = emailSend;
        }

        @Deprecated
        public String getRegistrationSend() {
            return this.registrationSent;
        }

        @Deprecated
        public void setRegistrationSend(String registrationSend) {
            this.registrationSent = registrationSend;
        }

        public int hashCode() {
            return Objects.hash(this.accountEdit, this.accountIndex, this.accountTwoFactorDisable, this.accountTwoFactorEnable, this.accountTwoFactorIndex, this.accountWebAuthnAdd, this.accountWebAuthnDelete, this.accountWebAuthnIndex, this.emailComplete, this.emailSent, this.emailVerificationRequired, this.emailVerify, this.helpers, this.index, this.oauth2Authorize, this.oauth2AuthorizedNotRegistered, this.oauth2ChildRegistrationNotAllowed, this.oauth2ChildRegistrationNotAllowedComplete, this.oauth2CompleteRegistration, this.oauth2Device, this.oauth2DeviceComplete, this.oauth2Error, this.oauth2Logout, this.oauth2Passwordless, this.oauth2Register, this.oauth2StartIdPLink, this.oauth2TwoFactor, this.oauth2TwoFactorMethods, this.oauth2Wait, this.oauth2WebAuthn, this.oauth2WebAuthnReauth, this.oauth2WebAuthnReauthEnable, this.passwordChange, this.passwordComplete, this.passwordForgot, this.passwordSent, this.registrationComplete, this.registrationSent, this.registrationVerificationRequired, this.registrationVerify, this.samlv2Logout, this.unauthorized);
        }

        public void normalize() {
            this.accountEdit = Normalizer.lineReturns(Normalizer.trimToNull(this.accountEdit));
            this.accountIndex = Normalizer.lineReturns(Normalizer.trimToNull(this.accountIndex));
            this.accountTwoFactorDisable = Normalizer.lineReturns(Normalizer.trimToNull(this.accountTwoFactorDisable));
            this.accountTwoFactorEnable = Normalizer.lineReturns(Normalizer.trimToNull(this.accountTwoFactorEnable));
            this.accountTwoFactorIndex = Normalizer.lineReturns(Normalizer.trimToNull(this.accountTwoFactorIndex));
            this.accountWebAuthnAdd = Normalizer.lineReturns(Normalizer.trimToNull(this.accountWebAuthnAdd));
            this.accountWebAuthnDelete = Normalizer.lineReturns(Normalizer.trimToNull(this.accountWebAuthnDelete));
            this.accountWebAuthnIndex = Normalizer.lineReturns(Normalizer.trimToNull(this.accountWebAuthnIndex));
            this.emailComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.emailComplete));
            this.emailSent = Normalizer.lineReturns(Normalizer.trimToNull(this.emailSent));
            this.emailVerificationRequired = Normalizer.lineReturns(Normalizer.trimToNull(this.emailVerificationRequired));
            this.emailVerify = Normalizer.lineReturns(Normalizer.trimToNull(this.emailVerify));
            this.helpers = Normalizer.lineReturns(Normalizer.trimToNull(this.helpers));
            this.index = Normalizer.lineReturns(Normalizer.trimToNull(this.index));
            this.oauth2Authorize = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Authorize));
            this.oauth2AuthorizedNotRegistered = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2AuthorizedNotRegistered));
            this.oauth2ChildRegistrationNotAllowed = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2ChildRegistrationNotAllowed));
            this.oauth2ChildRegistrationNotAllowedComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2ChildRegistrationNotAllowedComplete));
            this.oauth2CompleteRegistration = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2CompleteRegistration));
            this.oauth2Device = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Device));
            this.oauth2DeviceComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2DeviceComplete));
            this.oauth2Error = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Error));
            this.oauth2Logout = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Logout));
            this.oauth2Passwordless = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Passwordless));
            this.oauth2Register = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Register));
            this.oauth2StartIdPLink = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2StartIdPLink));
            this.oauth2TwoFactor = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2TwoFactor));
            this.oauth2TwoFactorMethods = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2TwoFactorMethods));
            this.oauth2Wait = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2Wait));
            this.oauth2WebAuthn = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2WebAuthn));
            this.oauth2WebAuthnReauth = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2WebAuthnReauth));
            this.oauth2WebAuthnReauthEnable = Normalizer.lineReturns(Normalizer.trimToNull(this.oauth2WebAuthnReauthEnable));
            this.passwordChange = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordChange));
            this.passwordComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordComplete));
            this.passwordForgot = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordForgot));
            this.passwordSent = Normalizer.lineReturns(Normalizer.trimToNull(this.passwordSent));
            this.registrationComplete = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationComplete));
            this.registrationSent = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationSent));
            this.registrationVerificationRequired = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationVerificationRequired));
            this.registrationVerify = Normalizer.lineReturns(Normalizer.trimToNull(this.registrationVerify));
            this.samlv2Logout = Normalizer.lineReturns(Normalizer.trimToNull(this.samlv2Logout));
            this.unauthorized = Normalizer.lineReturns(Normalizer.trimToNull(this.unauthorized));
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

