/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Location;
import io.fusionauth.domain.jwt.DeviceInfo;
import io.fusionauth.domain.jwt.RefreshToken;
import java.util.Map;
import java.util.Objects;

public class EventInfo
implements Buildable<EventInfo> {
    public Map<String, Object> data;
    public String deviceDescription;
    public String deviceName;
    public String deviceType;
    public String ipAddress;
    public Location location;
    public String os;
    public String userAgent;

    public EventInfo() {
    }

    public EventInfo(RefreshToken.MetaData metaData) {
        this.deviceDescription = metaData != null && metaData.device != null ? metaData.device.description : null;
        this.deviceName = metaData != null && metaData.device != null ? metaData.device.name : null;
        this.deviceType = metaData != null && metaData.device != null && metaData.device.type != null ? metaData.device.type.toString() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventInfo eventInfo = (EventInfo)o;
        return Objects.equals(this.deviceDescription, eventInfo.deviceDescription) && Objects.equals(this.data, eventInfo.data) && Objects.equals(this.deviceName, eventInfo.deviceName) && Objects.equals(this.deviceType, eventInfo.deviceType) && Objects.equals(this.ipAddress, eventInfo.ipAddress) && Objects.equals(this.location, eventInfo.location) && Objects.equals(this.os, eventInfo.os) && Objects.equals(this.userAgent, eventInfo.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.deviceDescription, this.deviceName, this.deviceType, this.ipAddress, this.location, this.os, this.userAgent);
    }

    public RefreshToken.MetaData toMetaData() {
        return new RefreshToken.MetaData().with(md -> {
            md.device = new DeviceInfo();
        }).with(md -> {
            md.device.description = this.deviceDescription;
        }).with(md -> {
            md.device.name = this.deviceName;
        }).with(md -> {
            md.device.type = DeviceInfo.DeviceType.safeValueOf(this.deviceType);
        });
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

