/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.TenantWebAuthnWorkflowConfiguration;
import io.fusionauth.domain.webauthn.AuthenticatorAttachmentPreference;
import io.fusionauth.domain.webauthn.UserVerificationRequirement;
import java.util.Objects;

public class TenantWebAuthnConfiguration
extends Enableable
implements Buildable<TenantWebAuthnConfiguration> {
    public TenantWebAuthnWorkflowConfiguration bootstrapWorkflow = new TenantWebAuthnWorkflowConfiguration().with(c -> {
        c.authenticatorAttachmentPreference = AuthenticatorAttachmentPreference.any;
    }).with(c -> {
        c.userVerificationRequirement = UserVerificationRequirement.required;
    });
    public boolean debug;
    public TenantWebAuthnWorkflowConfiguration reauthenticationWorkflow = new TenantWebAuthnWorkflowConfiguration().with(c -> {
        c.authenticatorAttachmentPreference = AuthenticatorAttachmentPreference.platform;
    }).with(c -> {
        c.userVerificationRequirement = UserVerificationRequirement.required;
    });
    public String relyingPartyId;
    public String relyingPartyName;

    @JacksonConstructor
    public TenantWebAuthnConfiguration() {
    }

    public TenantWebAuthnConfiguration(TenantWebAuthnConfiguration other) {
        this.bootstrapWorkflow = new TenantWebAuthnWorkflowConfiguration(other.bootstrapWorkflow);
        this.debug = other.debug;
        this.enabled = other.enabled;
        this.reauthenticationWorkflow = new TenantWebAuthnWorkflowConfiguration(other.reauthenticationWorkflow);
        this.relyingPartyId = other.relyingPartyId;
        this.relyingPartyName = other.relyingPartyName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TenantWebAuthnConfiguration)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantWebAuthnConfiguration that = (TenantWebAuthnConfiguration)o;
        return this.debug == that.debug && Objects.equals(this.bootstrapWorkflow, that.bootstrapWorkflow) && Objects.equals(this.reauthenticationWorkflow, that.reauthenticationWorkflow) && Objects.equals(this.relyingPartyId, that.relyingPartyId) && Objects.equals(this.relyingPartyName, that.relyingPartyName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.debug, this.bootstrapWorkflow, this.reauthenticationWorkflow, this.relyingPartyId, this.relyingPartyName);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

