/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.IPAccessControlEntry;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class IPAccessControlList
implements Buildable<IPAccessControlList> {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final Map<String, Object> data = new LinkedHashMap<String, Object>();
    public List<IPAccessControlEntry> entries = new ArrayList<IPAccessControlEntry>();
    public UUID id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastUpdateInstant;
    public String name;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPAccessControlList that = (IPAccessControlList)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.entries, that.entries) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.entries, this.id, this.insertInstant, this.lastUpdateInstant, this.name);
    }

    public IPAccessControlList normalize() {
        boolean hasDefault = false;
        Iterator<IPAccessControlEntry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            IPAccessControlEntry entry = iterator.next();
            if (!"*".equals(entry.startIPAddress)) continue;
            if (hasDefault) {
                iterator.remove();
                continue;
            }
            entry.endIPAddress = null;
            hasDefault = true;
        }
        this.entries.sort(Comparator.comparing(e -> e.startIPAddress, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(e -> e.endIPAddress, Comparator.nullsLast(Comparator.naturalOrder())));
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

