/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.jwt;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Application;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.RefreshTokenExpirationPolicy;
import io.fusionauth.domain.Tenant;
import io.fusionauth.domain.jwt.DeviceInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class RefreshToken
implements Buildable<RefreshToken> {
    public UUID applicationId;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public UUID id;
    public ZonedDateTime insertInstant;
    public MetaData metaData = new MetaData();
    public ZonedDateTime startInstant;
    public UUID tenantId;
    public String token;
    public UUID userId;

    @JacksonConstructor
    public RefreshToken() {
    }

    public RefreshToken(RefreshToken other) {
        this.applicationId = other.applicationId;
        if (other.data != null) {
            this.data.putAll(other.data);
        }
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.metaData = new MetaData(other.metaData);
        this.startInstant = other.startInstant;
        this.tenantId = other.tenantId;
        this.token = other.token;
        this.userId = other.userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefreshToken that = (RefreshToken)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.data, that.data) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.metaData, that.metaData) && Objects.equals(this.startInstant, that.startInstant) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.token, that.token) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.data, this.id, this.insertInstant, this.metaData, this.startInstant, this.tenantId, this.token, this.userId);
    }

    @JsonIgnore
    public boolean isExpired(Tenant tenant, Application application) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        JWTConfiguration jwtConfiguration = tenant.lookupJWTConfiguration(application);
        if (this.startInstant.plusMinutes(jwtConfiguration.refreshTokenTimeToLiveInMinutes).isBefore(now)) {
            return true;
        }
        return jwtConfiguration.refreshTokenExpirationPolicy == RefreshTokenExpirationPolicy.SlidingWindowWithMaximumLifetime && this.insertInstant.plusMinutes(jwtConfiguration.refreshTokenSlidingWindowConfiguration.maximumTimeToLiveInMinutes).isBefore(now);
    }

    public RefreshToken secure() {
        this.data = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class MetaData
    implements Buildable<MetaData> {
        public Map<String, Object> data;
        public DeviceInfo device = new DeviceInfo();
        @JsonDeserialize(as=LinkedHashSet.class)
        public Set<String> scopes;

        @JacksonConstructor
        public MetaData() {
        }

        public MetaData(MetaData other) {
            if (other.data != null) {
                this.data = new LinkedHashMap<String, Object>(other.data);
            }
            this.device = new DeviceInfo(other.device);
            if (other.scopes != null) {
                this.scopes = new LinkedHashSet<String>(other.scopes);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetaData)) {
                return false;
            }
            MetaData metaData = (MetaData)o;
            return Objects.equals(this.data, metaData.data) && Objects.equals(this.device, metaData.device) && Objects.equals(this.scopes, metaData.scopes);
        }

        public int hashCode() {
            return Objects.hash(this.data, this.device, this.scopes);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }
}

