/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.provider;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.DomainBasedIdentityProvider;
import io.fusionauth.domain.provider.ExternalJWTApplicationConfiguration;
import io.fusionauth.domain.provider.IdentityProviderOauth2Configuration;
import io.fusionauth.domain.provider.IdentityProviderType;
import io.fusionauth.domain.util.Normalizer;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class ExternalJWTIdentityProvider
extends BaseIdentityProvider<ExternalJWTApplicationConfiguration>
implements Buildable<ExternalJWTIdentityProvider>,
DomainBasedIdentityProvider {
    public final Map<String, String> claimMap = new LinkedHashMap<String, String>();
    public final Set<String> domains = new LinkedHashSet<String>();
    public UUID defaultKeyId;
    public String headerKeyParameter = "kid";
    public IdentityProviderOauth2Configuration oauth2 = new IdentityProviderOauth2Configuration();
    @Deprecated
    public String uniqueIdentityClaim;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalJWTIdentityProvider)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalJWTIdentityProvider that = (ExternalJWTIdentityProvider)o;
        return Objects.equals(this.claimMap, that.claimMap) && Objects.equals(this.defaultKeyId, that.defaultKeyId) && Objects.equals(this.headerKeyParameter, that.headerKeyParameter) && Objects.equals(this.oauth2, that.oauth2) && Objects.equals(this.uniqueIdentityClaim, that.uniqueIdentityClaim) && Objects.equals(this.domains, that.domains);
    }

    @Override
    public Set<String> getDomains() {
        return this.domains;
    }

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.ExternalJWT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.claimMap, this.defaultKeyId, this.headerKeyParameter, this.oauth2, this.uniqueIdentityClaim, this.domains);
    }

    @Override
    public void normalize() {
        super.normalize();
        Normalizer.toLowerCase(this.domains, HashSet::new);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

