/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.util;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public final class DefaultTools {
    public static <T> void addIfEmpty(List<T> value, T defaultValue) {
        if (value.isEmpty()) {
            value.add(defaultValue);
        }
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue);
    }

    public static <T> T defaultIfNull(T value, Supplier<T> defaultValue) {
        return Optional.ofNullable(value).orElse(defaultValue.get());
    }

    public static int defaultIfZero(int value, int defaultValue) {
        return value != 0 ? value : defaultValue;
    }

    public static long defaultIfZero(long value, long defaultValue) {
        return value != 0L ? value : defaultValue;
    }
}

