/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.MessageTemplateJacksonHelper;
import io.fusionauth.domain.api.MessageTemplateRequest;
import io.fusionauth.domain.message.MessageTemplate;
import io.fusionauth.domain.message.MessageType;
import java.io.IOException;

public class MessageTemplateRequestDeserializer
extends StdDeserializer<MessageTemplateRequest> {
    public MessageTemplateRequestDeserializer() {
        super(MessageTemplateRequest.class);
    }

    public MessageTemplateRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new MessageTemplateRequest());
    }

    public MessageTemplateRequest deserialize(JsonParser p, DeserializationContext ctxt, MessageTemplateRequest req) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode mNode = node.at("/messageTemplate");
        if (req.messageTemplate == null) {
            MessageType mType = MessageTemplateJacksonHelper.extractType(ctxt, p, mNode);
            req.messageTemplate = MessageTemplateJacksonHelper.newMessageTemplate(mType);
        }
        if (p.getCodec() instanceof ObjectMapper) {
            ((ObjectMapper)p.getCodec()).readerForUpdating((Object)req.messageTemplate).readValue(mNode);
        } else if (p.getCodec() instanceof ObjectReader) {
            req.messageTemplate = (MessageTemplate)((ObjectReader)p.getCodec()).readValue(mNode, req.messageTemplate.getClass());
        }
        return req;
    }
}

