/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.KeyUse;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class Key
implements Buildable<Key> {
    public KeyAlgorithm algorithm;
    public String certificate;
    public CertificateInformation certificateInformation;
    public ZonedDateTime expirationInstant;
    public Boolean hasPrivateKey;
    public UUID id;
    public ZonedDateTime insertInstant;
    public String issuer;
    public String kid;
    public ZonedDateTime lastUpdateInstant;
    public Integer length;
    public String name;
    public String privateKey;
    public String publicKey;
    public String secret;
    public KeyType type;

    @JacksonConstructor
    public Key() {
    }

    public Key(Key key) {
        this.algorithm = key.algorithm;
        this.certificate = key.certificate;
        this.certificateInformation = key.certificateInformation;
        this.expirationInstant = key.expirationInstant;
        this.hasPrivateKey = key.hasPrivateKey;
        this.id = key.id;
        this.insertInstant = key.insertInstant;
        this.issuer = key.issuer;
        this.kid = key.kid;
        this.lastUpdateInstant = key.lastUpdateInstant;
        this.length = key.length;
        this.name = key.name;
        this.privateKey = key.privateKey;
        this.publicKey = key.publicKey;
        this.secret = key.secret;
        this.type = key.type;
    }

    @JsonIgnore
    public boolean canSign() {
        return this.use() != KeyUse.VerifyOnly;
    }

    @JsonIgnore
    public boolean canVerify() {
        return this.use() != KeyUse.SignOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key key = (Key)o;
        return this.algorithm == key.algorithm && Objects.equals(this.certificate, key.certificate) && Objects.equals(this.certificateInformation, key.certificateInformation) && Objects.equals(this.expirationInstant, key.expirationInstant) && Objects.equals(this.hasPrivateKey, key.hasPrivateKey) && Objects.equals(this.id, key.id) && Objects.equals(this.insertInstant, key.insertInstant) && Objects.equals(this.issuer, key.issuer) && Objects.equals(this.kid, key.kid) && Objects.equals(this.lastUpdateInstant, key.lastUpdateInstant) && Objects.equals(this.length, key.length) && Objects.equals(this.name, key.name) && Objects.equals(this.privateKey, key.privateKey) && Objects.equals(this.publicKey, key.publicKey) && Objects.equals(this.secret, key.secret) && this.type == key.type;
    }

    @JsonIgnore
    public String getDisplayName() {
        if (this.algorithm == null) {
            return this.name + " (" + this.type.name() + ")";
        }
        return this.name + " (" + this.algorithm.name() + ")";
    }

    @JsonIgnore
    public boolean hasPrivateKey() {
        return this.privateKey != null || this.hasPrivateKey != null && this.hasPrivateKey != false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, this.certificate, this.certificateInformation, this.expirationInstant, this.hasPrivateKey, this.id, this.insertInstant, this.issuer, this.kid, this.lastUpdateInstant, this.length, this.name, this.privateKey, this.publicKey, this.secret, this.type});
    }

    @JsonIgnore
    public boolean isExpired() {
        if (this.expirationInstant == null) {
            return false;
        }
        return ZonedDateTime.now(ZoneOffset.UTC).isAfter(this.expirationInstant);
    }

    @JsonIgnore
    public boolean isPair() {
        return (this.publicKey != null || this.certificate != null) && this.hasPrivateKey();
    }

    public void normalize() {
        if (this.certificate != null) {
            this.certificate = this.certificate.replace("\r\n", "\n").replace("\r", "\n");
        }
        if (this.publicKey != null) {
            this.publicKey = this.publicKey.replace("\r\n", "\n").replace("\r", "\n");
        }
        if (this.privateKey != null) {
            this.privateKey = this.privateKey.replace("\r\n", "\n").replace("\r", "\n");
        }
    }

    @JsonIgnore
    public boolean privateKeyOnly() {
        return this.hasPrivateKey() && this.publicKey == null && this.certificate == null;
    }

    public Key secure() {
        this.privateKey = null;
        this.secret = null;
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    @JsonIgnore
    public boolean use(KeyUse use) {
        return this.use().equals((Object)use);
    }

    public KeyUse use() {
        if (this.algorithm != null && (this.isPair() || this.type == KeyType.HMAC)) {
            return KeyUse.SignAndVerify;
        }
        if (this.hasPrivateKey()) {
            return KeyUse.SignOnly;
        }
        return KeyUse.VerifyOnly;
    }

    public static enum KeyAlgorithm {
        ES256("SHA256withECDSA"),
        ES384("SHA384withECDSA"),
        ES512("SHA512withECDSA"),
        HS256("HmacSHA256"),
        HS384("HmacSHA384"),
        HS512("HmacSHA512"),
        RS256("SHA256withRSA"),
        RS384("SHA384withRSA"),
        RS512("SHA512withRSA");

        public String algorithm;

        private KeyAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getName() {
            return this.algorithm;
        }
    }

    public static class CertificateInformation {
        public String issuer;
        public String md5Fingerprint;
        public String serialNumber;
        public String sha1Fingerprint;
        public String sha1Thumbprint;
        public String sha256Fingerprint;
        public String sha256Thumbprint;
        public String subject;
        public ZonedDateTime validFrom;
        public ZonedDateTime validTo;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CertificateInformation)) {
                return false;
            }
            CertificateInformation that = (CertificateInformation)o;
            return Objects.equals(this.issuer, that.issuer) && Objects.equals(this.md5Fingerprint, that.md5Fingerprint) && Objects.equals(this.serialNumber, that.serialNumber) && Objects.equals(this.sha1Fingerprint, that.sha1Fingerprint) && Objects.equals(this.sha1Thumbprint, that.sha1Thumbprint) && Objects.equals(this.sha256Fingerprint, that.sha256Fingerprint) && Objects.equals(this.sha256Thumbprint, that.sha256Thumbprint) && Objects.equals(this.subject, that.subject) && Objects.equals(this.validFrom, that.validFrom) && Objects.equals(this.validTo, that.validTo);
        }

        public int hashCode() {
            return Objects.hash(this.issuer, this.md5Fingerprint, this.serialNumber, this.sha1Fingerprint, this.sha1Thumbprint, this.sha256Fingerprint, this.sha256Thumbprint, this.subject, this.validFrom, this.validTo);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static enum KeyType {
        EC,
        RSA,
        HMAC;

    }
}

