/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.inversoft.error.Errors;
import com.inversoft.json.JacksonModule;
import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.FormDataBodyHandler;
import com.inversoft.rest.JSONBodyHandler;
import com.inversoft.rest.JSONResponseHandler;
import com.inversoft.rest.RESTClient;
import io.fusionauth.domain.LambdaType;
import io.fusionauth.domain.OpenIdConfiguration;
import io.fusionauth.domain.api.APIKeyRequest;
import io.fusionauth.domain.api.APIKeyResponse;
import io.fusionauth.domain.api.ApplicationOAuthScopeRequest;
import io.fusionauth.domain.api.ApplicationOAuthScopeResponse;
import io.fusionauth.domain.api.ApplicationRequest;
import io.fusionauth.domain.api.ApplicationResponse;
import io.fusionauth.domain.api.ApplicationSearchRequest;
import io.fusionauth.domain.api.ApplicationSearchResponse;
import io.fusionauth.domain.api.AuditLogRequest;
import io.fusionauth.domain.api.AuditLogResponse;
import io.fusionauth.domain.api.AuditLogSearchRequest;
import io.fusionauth.domain.api.AuditLogSearchResponse;
import io.fusionauth.domain.api.ConnectorRequest;
import io.fusionauth.domain.api.ConnectorResponse;
import io.fusionauth.domain.api.ConsentRequest;
import io.fusionauth.domain.api.ConsentResponse;
import io.fusionauth.domain.api.ConsentSearchRequest;
import io.fusionauth.domain.api.ConsentSearchResponse;
import io.fusionauth.domain.api.EmailTemplateRequest;
import io.fusionauth.domain.api.EmailTemplateResponse;
import io.fusionauth.domain.api.EmailTemplateSearchRequest;
import io.fusionauth.domain.api.EmailTemplateSearchResponse;
import io.fusionauth.domain.api.EntityGrantRequest;
import io.fusionauth.domain.api.EntityGrantResponse;
import io.fusionauth.domain.api.EntityGrantSearchRequest;
import io.fusionauth.domain.api.EntityGrantSearchResponse;
import io.fusionauth.domain.api.EntityRequest;
import io.fusionauth.domain.api.EntityResponse;
import io.fusionauth.domain.api.EntitySearchRequest;
import io.fusionauth.domain.api.EntitySearchResponse;
import io.fusionauth.domain.api.EntityTypeRequest;
import io.fusionauth.domain.api.EntityTypeResponse;
import io.fusionauth.domain.api.EntityTypeSearchRequest;
import io.fusionauth.domain.api.EntityTypeSearchResponse;
import io.fusionauth.domain.api.EventLogResponse;
import io.fusionauth.domain.api.EventLogSearchRequest;
import io.fusionauth.domain.api.EventLogSearchResponse;
import io.fusionauth.domain.api.FamilyEmailRequest;
import io.fusionauth.domain.api.FamilyRequest;
import io.fusionauth.domain.api.FamilyResponse;
import io.fusionauth.domain.api.FormFieldRequest;
import io.fusionauth.domain.api.FormFieldResponse;
import io.fusionauth.domain.api.FormRequest;
import io.fusionauth.domain.api.FormResponse;
import io.fusionauth.domain.api.GroupMemberSearchRequest;
import io.fusionauth.domain.api.GroupMemberSearchResponse;
import io.fusionauth.domain.api.GroupRequest;
import io.fusionauth.domain.api.GroupResponse;
import io.fusionauth.domain.api.GroupSearchRequest;
import io.fusionauth.domain.api.GroupSearchResponse;
import io.fusionauth.domain.api.IPAccessControlListRequest;
import io.fusionauth.domain.api.IPAccessControlListResponse;
import io.fusionauth.domain.api.IPAccessControlListSearchRequest;
import io.fusionauth.domain.api.IPAccessControlListSearchResponse;
import io.fusionauth.domain.api.IdentityProviderRequest;
import io.fusionauth.domain.api.IdentityProviderResponse;
import io.fusionauth.domain.api.IdentityProviderSearchRequest;
import io.fusionauth.domain.api.IdentityProviderSearchResponse;
import io.fusionauth.domain.api.IntegrationRequest;
import io.fusionauth.domain.api.IntegrationResponse;
import io.fusionauth.domain.api.KeyRequest;
import io.fusionauth.domain.api.KeyResponse;
import io.fusionauth.domain.api.KeySearchRequest;
import io.fusionauth.domain.api.KeySearchResponse;
import io.fusionauth.domain.api.LambdaRequest;
import io.fusionauth.domain.api.LambdaResponse;
import io.fusionauth.domain.api.LambdaSearchRequest;
import io.fusionauth.domain.api.LambdaSearchResponse;
import io.fusionauth.domain.api.LoginPingRequest;
import io.fusionauth.domain.api.LoginRecordSearchRequest;
import io.fusionauth.domain.api.LoginRecordSearchResponse;
import io.fusionauth.domain.api.LoginRequest;
import io.fusionauth.domain.api.LoginResponse;
import io.fusionauth.domain.api.LogoutRequest;
import io.fusionauth.domain.api.MemberDeleteRequest;
import io.fusionauth.domain.api.MemberRequest;
import io.fusionauth.domain.api.MemberResponse;
import io.fusionauth.domain.api.MessageTemplateRequest;
import io.fusionauth.domain.api.MessageTemplateResponse;
import io.fusionauth.domain.api.MessengerRequest;
import io.fusionauth.domain.api.MessengerResponse;
import io.fusionauth.domain.api.OAuthConfigurationResponse;
import io.fusionauth.domain.api.PasswordValidationRulesResponse;
import io.fusionauth.domain.api.PendingResponse;
import io.fusionauth.domain.api.PreviewMessageTemplateRequest;
import io.fusionauth.domain.api.PreviewMessageTemplateResponse;
import io.fusionauth.domain.api.PreviewRequest;
import io.fusionauth.domain.api.PreviewResponse;
import io.fusionauth.domain.api.PublicKeyResponse;
import io.fusionauth.domain.api.ReactorMetricsResponse;
import io.fusionauth.domain.api.ReactorRequest;
import io.fusionauth.domain.api.ReactorResponse;
import io.fusionauth.domain.api.ReindexRequest;
import io.fusionauth.domain.api.StatusResponse;
import io.fusionauth.domain.api.SystemConfigurationRequest;
import io.fusionauth.domain.api.SystemConfigurationResponse;
import io.fusionauth.domain.api.TenantDeleteRequest;
import io.fusionauth.domain.api.TenantRequest;
import io.fusionauth.domain.api.TenantResponse;
import io.fusionauth.domain.api.TenantSearchRequest;
import io.fusionauth.domain.api.TenantSearchResponse;
import io.fusionauth.domain.api.ThemeRequest;
import io.fusionauth.domain.api.ThemeResponse;
import io.fusionauth.domain.api.ThemeSearchRequest;
import io.fusionauth.domain.api.ThemeSearchResponse;
import io.fusionauth.domain.api.TwoFactorDisableRequest;
import io.fusionauth.domain.api.TwoFactorRecoveryCodeResponse;
import io.fusionauth.domain.api.TwoFactorRequest;
import io.fusionauth.domain.api.TwoFactorResponse;
import io.fusionauth.domain.api.UserActionReasonRequest;
import io.fusionauth.domain.api.UserActionReasonResponse;
import io.fusionauth.domain.api.UserActionRequest;
import io.fusionauth.domain.api.UserActionResponse;
import io.fusionauth.domain.api.UserCommentRequest;
import io.fusionauth.domain.api.UserCommentResponse;
import io.fusionauth.domain.api.UserCommentSearchRequest;
import io.fusionauth.domain.api.UserCommentSearchResponse;
import io.fusionauth.domain.api.UserConsentRequest;
import io.fusionauth.domain.api.UserConsentResponse;
import io.fusionauth.domain.api.UserDeleteRequest;
import io.fusionauth.domain.api.UserDeleteResponse;
import io.fusionauth.domain.api.UserDeleteSingleRequest;
import io.fusionauth.domain.api.UserRequest;
import io.fusionauth.domain.api.UserResponse;
import io.fusionauth.domain.api.VersionResponse;
import io.fusionauth.domain.api.WebAuthnAssertResponse;
import io.fusionauth.domain.api.WebAuthnCredentialImportRequest;
import io.fusionauth.domain.api.WebAuthnCredentialResponse;
import io.fusionauth.domain.api.WebAuthnLoginRequest;
import io.fusionauth.domain.api.WebAuthnRegisterCompleteRequest;
import io.fusionauth.domain.api.WebAuthnRegisterCompleteResponse;
import io.fusionauth.domain.api.WebAuthnRegisterStartRequest;
import io.fusionauth.domain.api.WebAuthnRegisterStartResponse;
import io.fusionauth.domain.api.WebAuthnStartRequest;
import io.fusionauth.domain.api.WebAuthnStartResponse;
import io.fusionauth.domain.api.WebhookAttemptLogResponse;
import io.fusionauth.domain.api.WebhookEventLogResponse;
import io.fusionauth.domain.api.WebhookEventLogSearchRequest;
import io.fusionauth.domain.api.WebhookEventLogSearchResponse;
import io.fusionauth.domain.api.WebhookRequest;
import io.fusionauth.domain.api.WebhookResponse;
import io.fusionauth.domain.api.WebhookSearchRequest;
import io.fusionauth.domain.api.WebhookSearchResponse;
import io.fusionauth.domain.api.email.SendRequest;
import io.fusionauth.domain.api.email.SendResponse;
import io.fusionauth.domain.api.identityProvider.IdentityProviderLinkRequest;
import io.fusionauth.domain.api.identityProvider.IdentityProviderLinkResponse;
import io.fusionauth.domain.api.identityProvider.IdentityProviderLoginRequest;
import io.fusionauth.domain.api.identityProvider.IdentityProviderPendingLinkResponse;
import io.fusionauth.domain.api.identityProvider.IdentityProviderStartLoginRequest;
import io.fusionauth.domain.api.identityProvider.IdentityProviderStartLoginResponse;
import io.fusionauth.domain.api.identityProvider.LookupResponse;
import io.fusionauth.domain.api.jwt.IssueResponse;
import io.fusionauth.domain.api.jwt.JWTRefreshResponse;
import io.fusionauth.domain.api.jwt.JWTVendRequest;
import io.fusionauth.domain.api.jwt.JWTVendResponse;
import io.fusionauth.domain.api.jwt.RefreshRequest;
import io.fusionauth.domain.api.jwt.RefreshTokenResponse;
import io.fusionauth.domain.api.jwt.RefreshTokenRevokeRequest;
import io.fusionauth.domain.api.jwt.ValidateResponse;
import io.fusionauth.domain.api.passwordless.PasswordlessLoginRequest;
import io.fusionauth.domain.api.passwordless.PasswordlessSendRequest;
import io.fusionauth.domain.api.passwordless.PasswordlessStartRequest;
import io.fusionauth.domain.api.passwordless.PasswordlessStartResponse;
import io.fusionauth.domain.api.report.DailyActiveUserReportResponse;
import io.fusionauth.domain.api.report.LoginReportResponse;
import io.fusionauth.domain.api.report.MonthlyActiveUserReportResponse;
import io.fusionauth.domain.api.report.RegistrationReportResponse;
import io.fusionauth.domain.api.report.TotalsReportResponse;
import io.fusionauth.domain.api.twoFactor.SecretResponse;
import io.fusionauth.domain.api.twoFactor.TwoFactorLoginRequest;
import io.fusionauth.domain.api.twoFactor.TwoFactorSendRequest;
import io.fusionauth.domain.api.twoFactor.TwoFactorStartRequest;
import io.fusionauth.domain.api.twoFactor.TwoFactorStartResponse;
import io.fusionauth.domain.api.twoFactor.TwoFactorStatusResponse;
import io.fusionauth.domain.api.user.ActionRequest;
import io.fusionauth.domain.api.user.ActionResponse;
import io.fusionauth.domain.api.user.ChangePasswordRequest;
import io.fusionauth.domain.api.user.ChangePasswordResponse;
import io.fusionauth.domain.api.user.ForgotPasswordRequest;
import io.fusionauth.domain.api.user.ForgotPasswordResponse;
import io.fusionauth.domain.api.user.ImportRequest;
import io.fusionauth.domain.api.user.RecentLoginResponse;
import io.fusionauth.domain.api.user.RefreshTokenImportRequest;
import io.fusionauth.domain.api.user.RegistrationDeleteRequest;
import io.fusionauth.domain.api.user.RegistrationRequest;
import io.fusionauth.domain.api.user.RegistrationResponse;
import io.fusionauth.domain.api.user.SearchRequest;
import io.fusionauth.domain.api.user.SearchResponse;
import io.fusionauth.domain.api.user.VerifyEmailRequest;
import io.fusionauth.domain.api.user.VerifyEmailResponse;
import io.fusionauth.domain.api.user.VerifyRegistrationRequest;
import io.fusionauth.domain.api.user.VerifyRegistrationResponse;
import io.fusionauth.domain.oauth2.AccessToken;
import io.fusionauth.domain.oauth2.DeviceApprovalResponse;
import io.fusionauth.domain.oauth2.IntrospectResponse;
import io.fusionauth.domain.oauth2.JWKSResponse;
import io.fusionauth.domain.oauth2.OAuthError;
import io.fusionauth.domain.oauth2.UserinfoResponse;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FusionAuthClient {
    public static String TENANT_ID_HEADER = "X-FusionAuth-TenantId";
    public static final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true).configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true).registerModule((Module)new JacksonModule());
    private final String apiKey;
    private final String baseURL;
    private final ObjectMapper customMapper;
    private final String tenantId;
    public int connectTimeout;
    public int readTimeout;

    public FusionAuthClient(String apiKey, String baseURL) {
        this(apiKey, baseURL, null);
    }

    public FusionAuthClient(String apiKey, String baseURL, String tenantId) {
        this(apiKey, baseURL, 2000, 2000, tenantId);
    }

    public FusionAuthClient(String apiKey, String baseURL, int connectTimeout, int readTimeout) {
        this(apiKey, baseURL, connectTimeout, readTimeout, null);
    }

    public FusionAuthClient(String apiKey, String baseURL, int connectTimeout, int readTimeout, String tenantId) {
        this(apiKey, baseURL, connectTimeout, readTimeout, tenantId, null);
    }

    public FusionAuthClient(String apiKey, String baseURL, int connectTimeout, int readTimeout, String tenantId, ObjectMapper objectMapper) {
        this.apiKey = apiKey;
        this.baseURL = baseURL;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.tenantId = tenantId;
        this.customMapper = objectMapper;
    }

    public FusionAuthClient setTenantId(UUID tenantId) {
        if (tenantId == null) {
            return this;
        }
        return new FusionAuthClient(this.apiKey, this.baseURL, this.connectTimeout, this.readTimeout, tenantId.toString());
    }

    public FusionAuthClient setObjectMapper(ObjectMapper objectMapper) {
        return new FusionAuthClient(this.apiKey, this.baseURL, this.connectTimeout, this.readTimeout, this.tenantId, objectMapper);
    }

    public ClientResponse<ActionResponse, Errors> actionUser(ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> activateReactor(ReactorRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/reactor").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<FamilyResponse, Errors> addUserToFamily(UUID familyId, FamilyRequest request) {
        return this.start(FamilyResponse.class, Errors.class).uri("/api/user/family").urlSegment((Object)familyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<DeviceApprovalResponse, Errors> approveDevice(String client_id, String client_secret, String token, String user_code) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("token", Arrays.asList(token));
        parameters.put("user_code", Arrays.asList(user_code));
        return this.start(DeviceApprovalResponse.class, Errors.class).uri("/oauth2/device/approve").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<ActionResponse, Errors> cancelAction(UUID actionId, ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<ChangePasswordResponse, Errors> changePassword(String changePasswordId, ChangePasswordRequest request) {
        return this.startAnonymous(ChangePasswordResponse.class, Errors.class).uri("/api/user/change-password").urlSegment((Object)changePasswordId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> changePasswordByIdentity(ChangePasswordRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/change-password").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> checkChangePasswordUsingId(String changePasswordId) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/change-password").urlSegment((Object)changePasswordId).get().go();
    }

    public ClientResponse<Void, Errors> checkChangePasswordUsingJWT(String encodedJWT) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/change-password").authorization("Bearer " + encodedJWT).get().go();
    }

    public ClientResponse<Void, Errors> checkChangePasswordUsingLoginId(String loginId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/change-password").urlParameter("username", loginId).get().go();
    }

    public ClientResponse<AccessToken, OAuthError> clientCredentialsGrant(String client_id, String client_secret, String scope) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("grant_type", Arrays.asList("client_credentials"));
        parameters.put("scope", Arrays.asList(scope));
        return this.startAnonymous(AccessToken.class, OAuthError.class).uri("/oauth2/token").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<UserCommentResponse, Errors> commentOnUser(UserCommentRequest request) {
        return this.start(UserCommentResponse.class, Errors.class).uri("/api/user/comment").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebAuthnAssertResponse, Errors> completeWebAuthnAssertion(WebAuthnLoginRequest request) {
        return this.startAnonymous(WebAuthnAssertResponse.class, Errors.class).uri("/api/webauthn/assert").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LoginResponse, Errors> completeWebAuthnLogin(WebAuthnLoginRequest request) {
        return this.startAnonymous(LoginResponse.class, Errors.class).uri("/api/webauthn/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebAuthnRegisterCompleteResponse, Errors> completeWebAuthnRegistration(WebAuthnRegisterCompleteRequest request) {
        return this.start(WebAuthnRegisterCompleteResponse.class, Errors.class).uri("/api/webauthn/register/complete").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<APIKeyResponse, Errors> createAPIKey(UUID keyId, APIKeyRequest request) {
        return this.start(APIKeyResponse.class, Errors.class).uri("/api/api-key").urlSegment((Object)keyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> createApplication(UUID applicationId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> createApplicationRole(UUID applicationId, UUID roleId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<AuditLogResponse, Errors> createAuditLog(AuditLogRequest request) {
        return this.start(AuditLogResponse.class, Errors.class).uri("/api/system/audit-log").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ConnectorResponse, Errors> createConnector(UUID connectorId, ConnectorRequest request) {
        return this.start(ConnectorResponse.class, Errors.class).uri("/api/connector").urlSegment((Object)connectorId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ConsentResponse, Errors> createConsent(UUID consentId, ConsentRequest request) {
        return this.start(ConsentResponse.class, Errors.class).uri("/api/consent").urlSegment((Object)consentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EmailTemplateResponse, Errors> createEmailTemplate(UUID emailTemplateId, EmailTemplateRequest request) {
        return this.start(EmailTemplateResponse.class, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntityResponse, Errors> createEntity(UUID entityId, EntityRequest request) {
        return this.start(EntityResponse.class, Errors.class).uri("/api/entity").urlSegment((Object)entityId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> createEntityType(UUID entityTypeId, EntityTypeRequest request) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> createEntityTypePermission(UUID entityTypeId, UUID permissionId, EntityTypeRequest request) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).urlSegment((Object)"permission").urlSegment((Object)permissionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<FamilyResponse, Errors> createFamily(UUID familyId, FamilyRequest request) {
        return this.start(FamilyResponse.class, Errors.class).uri("/api/user/family").urlSegment((Object)familyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<FormResponse, Errors> createForm(UUID formId, FormRequest request) {
        return this.start(FormResponse.class, Errors.class).uri("/api/form").urlSegment((Object)formId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<FormFieldResponse, Errors> createFormField(UUID fieldId, FormFieldRequest request) {
        return this.start(FormFieldResponse.class, Errors.class).uri("/api/form/field").urlSegment((Object)fieldId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<GroupResponse, Errors> createGroup(UUID groupId, GroupRequest request) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<MemberResponse, Errors> createGroupMembers(MemberRequest request) {
        return this.start(MemberResponse.class, Errors.class).uri("/api/group/member").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IPAccessControlListResponse, Errors> createIPAccessControlList(UUID accessControlListId, IPAccessControlListRequest request) {
        return this.start(IPAccessControlListResponse.class, Errors.class).uri("/api/ip-acl").urlSegment((Object)accessControlListId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> createIdentityProvider(UUID identityProviderId, IdentityProviderRequest request) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LambdaResponse, Errors> createLambda(UUID lambdaId, LambdaRequest request) {
        return this.start(LambdaResponse.class, Errors.class).uri("/api/lambda").urlSegment((Object)lambdaId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<MessageTemplateResponse, Errors> createMessageTemplate(UUID messageTemplateId, MessageTemplateRequest request) {
        return this.start(MessageTemplateResponse.class, Errors.class).uri("/api/message/template").urlSegment((Object)messageTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<MessengerResponse, Errors> createMessenger(UUID messengerId, MessengerRequest request) {
        return this.start(MessengerResponse.class, Errors.class).uri("/api/messenger").urlSegment((Object)messengerId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ApplicationOAuthScopeResponse, Errors> createOAuthScope(UUID applicationId, UUID scopeId, ApplicationOAuthScopeRequest request) {
        return this.start(ApplicationOAuthScopeResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"scope").urlSegment((Object)scopeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<TenantResponse, Errors> createTenant(UUID tenantId, TenantRequest request) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ThemeResponse, Errors> createTheme(UUID themeId, ThemeRequest request) {
        return this.start(ThemeResponse.class, Errors.class).uri("/api/theme").urlSegment((Object)themeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<UserResponse, Errors> createUser(UUID userId, UserRequest request) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<UserActionResponse, Errors> createUserAction(UUID userActionId, UserActionRequest request) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<UserActionReasonResponse, Errors> createUserActionReason(UUID userActionReasonId, UserActionReasonRequest request) {
        return this.start(UserActionReasonResponse.class, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<UserConsentResponse, Errors> createUserConsent(UUID userConsentId, UserConsentRequest request) {
        return this.start(UserConsentResponse.class, Errors.class).uri("/api/user/consent").urlSegment((Object)userConsentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IdentityProviderLinkResponse, Errors> createUserLink(IdentityProviderLinkRequest request) {
        return this.start(IdentityProviderLinkResponse.class, Errors.class).uri("/api/identity-provider/link").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebhookResponse, Errors> createWebhook(UUID webhookId, WebhookRequest request) {
        return this.start(WebhookResponse.class, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> deactivateApplication(UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Void> deactivateReactor() {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/reactor").delete().go();
    }

    public ClientResponse<Void, Errors> deactivateUser(UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user").urlSegment((Object)userId).delete().go();
    }

    public ClientResponse<Void, Errors> deactivateUserAction(UUID userActionId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).delete().go();
    }

    @Deprecated
    public ClientResponse<UserDeleteResponse, Errors> deactivateUsers(Collection<UUID> userIds) {
        return this.start(UserDeleteResponse.class, Errors.class).uri("/api/user/bulk").urlParameter("userId", userIds).urlParameter("dryRun", (Object)false).urlParameter("hardDelete", (Object)false).delete().go();
    }

    public ClientResponse<UserDeleteResponse, Errors> deactivateUsersByIds(Collection<UUID> userIds) {
        return this.start(UserDeleteResponse.class, Errors.class).uri("/api/user/bulk").urlParameter("userId", userIds).urlParameter("dryRun", (Object)false).urlParameter("hardDelete", (Object)false).delete().go();
    }

    public ClientResponse<Void, Errors> deleteAPIKey(UUID keyId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/api-key").urlSegment((Object)keyId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteApplication(UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteApplicationRole(UUID applicationId, UUID roleId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteConnector(UUID connectorId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/connector").urlSegment((Object)connectorId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteConsent(UUID consentId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/consent").urlSegment((Object)consentId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEmailTemplate(UUID emailTemplateId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEntity(UUID entityId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/entity").urlSegment((Object)entityId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEntityGrant(UUID entityId, UUID recipientEntityId, UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/entity").urlSegment((Object)entityId).urlSegment((Object)"grant").urlParameter("recipientEntityId", (Object)recipientEntityId).urlParameter("userId", (Object)userId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEntityType(UUID entityTypeId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteEntityTypePermission(UUID entityTypeId, UUID permissionId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).urlSegment((Object)"permission").urlSegment((Object)permissionId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteForm(UUID formId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/form").urlSegment((Object)formId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteFormField(UUID fieldId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/form/field").urlSegment((Object)fieldId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteGroup(UUID groupId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/group").urlSegment((Object)groupId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteGroupMembers(MemberDeleteRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/group/member").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<Void, Errors> deleteIPAccessControlList(UUID ipAccessControlListId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/ip-acl").urlSegment((Object)ipAccessControlListId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteIdentityProvider(UUID identityProviderId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteKey(UUID keyId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/key").urlSegment((Object)keyId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteLambda(UUID lambdaId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/lambda").urlSegment((Object)lambdaId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteMessageTemplate(UUID messageTemplateId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/message/template").urlSegment((Object)messageTemplateId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteMessenger(UUID messengerId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/messenger").urlSegment((Object)messengerId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteOAuthScope(UUID applicationId, UUID scopeId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"scope").urlSegment((Object)scopeId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteRegistration(UUID userId, UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).urlSegment((Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteRegistrationWithRequest(UUID userId, UUID applicationId, RegistrationDeleteRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<Void, Errors> deleteTenant(UUID tenantId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteTenantAsync(UUID tenantId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).urlParameter("async", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteTenantWithRequest(UUID tenantId, TenantDeleteRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<Void, Errors> deleteTheme(UUID themeId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/theme").urlSegment((Object)themeId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUser(UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user").urlSegment((Object)userId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUserAction(UUID userActionId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).urlParameter("hardDelete", (Object)true).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUserActionReason(UUID userActionReasonId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).delete().go();
    }

    public ClientResponse<IdentityProviderLinkResponse, Errors> deleteUserLink(UUID identityProviderId, String identityProviderUserId, UUID userId) {
        return this.start(IdentityProviderLinkResponse.class, Errors.class).uri("/api/identity-provider/link").urlParameter("identityProviderId", (Object)identityProviderId).urlParameter("identityProviderUserId", identityProviderUserId).urlParameter("userId", (Object)userId).delete().go();
    }

    public ClientResponse<Void, Errors> deleteUserWithRequest(UUID userId, UserDeleteSingleRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    @Deprecated
    public ClientResponse<UserDeleteResponse, Errors> deleteUsers(UserDeleteRequest request) {
        return this.start(UserDeleteResponse.class, Errors.class).uri("/api/user/bulk").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<UserDeleteResponse, Errors> deleteUsersByQuery(UserDeleteRequest request) {
        return this.start(UserDeleteResponse.class, Errors.class).uri("/api/user/bulk").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<Void, Errors> deleteWebAuthnCredential(UUID id) {
        return this.start(Void.TYPE, Errors.class).uri("/api/webauthn").urlSegment((Object)id).delete().go();
    }

    public ClientResponse<Void, Errors> deleteWebhook(UUID webhookId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).delete().go();
    }

    public ClientResponse<Void, Errors> disableTwoFactor(UUID userId, String methodId, String code) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/two-factor").urlSegment((Object)userId).urlParameter("methodId", methodId).urlParameter("code", code).delete().go();
    }

    public ClientResponse<Void, Errors> disableTwoFactorWithRequest(UUID userId, TwoFactorDisableRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/two-factor").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<TwoFactorResponse, Errors> enableTwoFactor(UUID userId, TwoFactorRequest request) {
        return this.start(TwoFactorResponse.class, Errors.class).uri("/api/user/two-factor").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<AccessToken, OAuthError> exchangeOAuthCodeForAccessToken(String code, String client_id, String client_secret, String redirect_uri) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("code", Arrays.asList(code));
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("grant_type", Arrays.asList("authorization_code"));
        parameters.put("redirect_uri", Arrays.asList(redirect_uri));
        return this.startAnonymous(AccessToken.class, OAuthError.class).uri("/oauth2/token").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<AccessToken, OAuthError> exchangeOAuthCodeForAccessTokenUsingPKCE(String code, String client_id, String client_secret, String redirect_uri, String code_verifier) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("code", Arrays.asList(code));
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("grant_type", Arrays.asList("authorization_code"));
        parameters.put("redirect_uri", Arrays.asList(redirect_uri));
        parameters.put("code_verifier", Arrays.asList(code_verifier));
        return this.startAnonymous(AccessToken.class, OAuthError.class).uri("/oauth2/token").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<AccessToken, OAuthError> exchangeRefreshTokenForAccessToken(String refresh_token, String client_id, String client_secret, String scope, String user_code) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("refresh_token", Arrays.asList(refresh_token));
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("grant_type", Arrays.asList("refresh_token"));
        parameters.put("scope", Arrays.asList(scope));
        parameters.put("user_code", Arrays.asList(user_code));
        return this.startAnonymous(AccessToken.class, OAuthError.class).uri("/oauth2/token").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<JWTRefreshResponse, Errors> exchangeRefreshTokenForJWT(RefreshRequest request) {
        return this.startAnonymous(JWTRefreshResponse.class, Errors.class).uri("/api/jwt/refresh").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<AccessToken, OAuthError> exchangeUserCredentialsForAccessToken(String username, String password, String client_id, String client_secret, String scope, String user_code) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("username", Arrays.asList(username));
        parameters.put("password", Arrays.asList(password));
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("grant_type", Arrays.asList("password"));
        parameters.put("scope", Arrays.asList(scope));
        parameters.put("user_code", Arrays.asList(user_code));
        return this.startAnonymous(AccessToken.class, OAuthError.class).uri("/oauth2/token").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<ForgotPasswordResponse, Errors> forgotPassword(ForgotPasswordRequest request) {
        return this.start(ForgotPasswordResponse.class, Errors.class).uri("/api/user/forgot-password").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<VerifyEmailResponse, Void> generateEmailVerificationId(String email) {
        return this.start(VerifyEmailResponse.class, Void.TYPE).uri("/api/user/verify-email").urlParameter("email", email).urlParameter("sendVerifyEmail", (Object)false).put().go();
    }

    public ClientResponse<KeyResponse, Errors> generateKey(UUID keyId, KeyRequest request) {
        return this.start(KeyResponse.class, Errors.class).uri("/api/key/generate").urlSegment((Object)keyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<VerifyRegistrationResponse, Void> generateRegistrationVerificationId(String email, UUID applicationId) {
        return this.start(VerifyRegistrationResponse.class, Void.TYPE).uri("/api/user/verify-registration").urlParameter("email", email).urlParameter("sendVerifyPasswordEmail", (Object)false).urlParameter("applicationId", (Object)applicationId).put().go();
    }

    public ClientResponse<TwoFactorRecoveryCodeResponse, Errors> generateTwoFactorRecoveryCodes(UUID userId) {
        return this.start(TwoFactorRecoveryCodeResponse.class, Errors.class).uri("/api/user/two-factor/recovery-code").urlSegment((Object)userId).post().go();
    }

    public ClientResponse<SecretResponse, Void> generateTwoFactorSecret() {
        return this.start(SecretResponse.class, Void.TYPE).uri("/api/two-factor/secret").get().go();
    }

    public ClientResponse<SecretResponse, Void> generateTwoFactorSecretUsingJWT(String encodedJWT) {
        return this.startAnonymous(SecretResponse.class, Void.TYPE).uri("/api/two-factor/secret").authorization("Bearer " + encodedJWT).get().go();
    }

    public ClientResponse<LoginResponse, Errors> identityProviderLogin(IdentityProviderLoginRequest request) {
        return this.startAnonymous(LoginResponse.class, Errors.class).uri("/api/identity-provider/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<KeyResponse, Errors> importKey(UUID keyId, KeyRequest request) {
        return this.start(KeyResponse.class, Errors.class).uri("/api/key/import").urlSegment((Object)keyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> importRefreshTokens(RefreshTokenImportRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/refresh-token/import").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> importUsers(ImportRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/import").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> importWebAuthnCredential(WebAuthnCredentialImportRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/webauthn/import").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IntrospectResponse, OAuthError> introspectAccessToken(String client_id, String token) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("token", Arrays.asList(token));
        return this.startAnonymous(IntrospectResponse.class, OAuthError.class).uri("/oauth2/introspect").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<IntrospectResponse, OAuthError> introspectClientCredentialsAccessToken(String token) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("token", Arrays.asList(token));
        return this.startAnonymous(IntrospectResponse.class, OAuthError.class).uri("/oauth2/introspect").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).post().go();
    }

    public ClientResponse<IssueResponse, Errors> issueJWT(UUID applicationId, String encodedJWT, String refreshToken) {
        return this.startAnonymous(IssueResponse.class, Errors.class).uri("/api/jwt/issue").authorization("Bearer " + encodedJWT).urlParameter("applicationId", (Object)applicationId).urlParameter("refreshToken", refreshToken).get().go();
    }

    public ClientResponse<LoginResponse, Errors> login(LoginRequest request) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LoginResponse, Errors> loginPing(UUID userId, UUID applicationId, String callerIPAddress) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/login").urlSegment((Object)userId).urlSegment((Object)applicationId).urlParameter("ipAddress", callerIPAddress).put().go();
    }

    public ClientResponse<LoginResponse, Errors> loginPingWithRequest(LoginPingRequest request) {
        return this.start(LoginResponse.class, Errors.class).uri("/api/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<Void, Void> logout(boolean global, String refreshToken) {
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/api/logout").urlParameter("global", (Object)global).urlParameter("refreshToken", refreshToken).post().go();
    }

    public ClientResponse<Void, Void> logoutWithRequest(LogoutRequest request) {
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/api/logout").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LookupResponse, Void> lookupIdentityProvider(String domain) {
        return this.start(LookupResponse.class, Void.TYPE).uri("/api/identity-provider/lookup").urlParameter("domain", domain).get().go();
    }

    public ClientResponse<ActionResponse, Errors> modifyAction(UUID actionId, ActionRequest request) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<LoginResponse, Errors> passwordlessLogin(PasswordlessLoginRequest request) {
        return this.startAnonymous(LoginResponse.class, Errors.class).uri("/api/passwordless/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<APIKeyResponse, Errors> patchAPIKey(UUID keyId, APIKeyRequest request) {
        return this.start(APIKeyResponse.class, Errors.class).uri("/api/api-key").urlSegment((Object)keyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ApplicationResponse, Errors> patchApplication(UUID applicationId, Map<String, Object> request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ApplicationResponse, Errors> patchApplicationRole(UUID applicationId, UUID roleId, Map<String, Object> request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ConnectorResponse, Errors> patchConnector(UUID connectorId, Map<String, Object> request) {
        return this.start(ConnectorResponse.class, Errors.class).uri("/api/connector").urlSegment((Object)connectorId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ConsentResponse, Errors> patchConsent(UUID consentId, Map<String, Object> request) {
        return this.start(ConsentResponse.class, Errors.class).uri("/api/consent").urlSegment((Object)consentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<EmailTemplateResponse, Errors> patchEmailTemplate(UUID emailTemplateId, Map<String, Object> request) {
        return this.start(EmailTemplateResponse.class, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> patchEntityType(UUID entityTypeId, Map<String, Object> request) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<GroupResponse, Errors> patchGroup(UUID groupId, Map<String, Object> request) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> patchIdentityProvider(UUID identityProviderId, Map<String, Object> request) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<IntegrationResponse, Errors> patchIntegrations(Map<String, Object> request) {
        return this.start(IntegrationResponse.class, Errors.class).uri("/api/integration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<LambdaResponse, Errors> patchLambda(UUID lambdaId, Map<String, Object> request) {
        return this.start(LambdaResponse.class, Errors.class).uri("/api/lambda").urlSegment((Object)lambdaId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<MessageTemplateResponse, Errors> patchMessageTemplate(UUID messageTemplateId, Map<String, Object> request) {
        return this.start(MessageTemplateResponse.class, Errors.class).uri("/api/message/template").urlSegment((Object)messageTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<MessengerResponse, Errors> patchMessenger(UUID messengerId, Map<String, Object> request) {
        return this.start(MessengerResponse.class, Errors.class).uri("/api/messenger").urlSegment((Object)messengerId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ApplicationOAuthScopeResponse, Errors> patchOAuthScope(UUID applicationId, UUID scopeId, Map<String, Object> request) {
        return this.start(ApplicationOAuthScopeResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"scope").urlSegment((Object)scopeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<RegistrationResponse, Errors> patchRegistration(UUID userId, Map<String, Object> request) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<SystemConfigurationResponse, Errors> patchSystemConfiguration(Map<String, Object> request) {
        return this.start(SystemConfigurationResponse.class, Errors.class).uri("/api/system-configuration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<TenantResponse, Errors> patchTenant(UUID tenantId, Map<String, Object> request) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ThemeResponse, Errors> patchTheme(UUID themeId, Map<String, Object> request) {
        return this.start(ThemeResponse.class, Errors.class).uri("/api/theme").urlSegment((Object)themeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<UserResponse, Errors> patchUser(UUID userId, Map<String, Object> request) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<UserActionResponse, Errors> patchUserAction(UUID userActionId, Map<String, Object> request) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<UserActionReasonResponse, Errors> patchUserActionReason(UUID userActionReasonId, Map<String, Object> request) {
        return this.start(UserActionReasonResponse.class, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<UserConsentResponse, Errors> patchUserConsent(UUID userConsentId, Map<String, Object> request) {
        return this.start(UserConsentResponse.class, Errors.class).uri("/api/user/consent").urlSegment((Object)userConsentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler(request, this.objectMapper())).patch().go();
    }

    public ClientResponse<ApplicationResponse, Errors> reactivateApplication(UUID applicationId) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<UserResponse, Errors> reactivateUser(UUID userId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<UserActionResponse, Errors> reactivateUserAction(UUID userActionId) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).urlParameter("reactivate", (Object)true).put().go();
    }

    public ClientResponse<LoginResponse, Errors> reconcileJWT(IdentityProviderLoginRequest request) {
        return this.startAnonymous(LoginResponse.class, Errors.class).uri("/api/jwt/reconcile").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Void> refreshEntitySearchIndex() {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/entity/search").put().go();
    }

    public ClientResponse<Void, Void> refreshUserSearchIndex() {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/user/search").put().go();
    }

    public ClientResponse<Void, Void> regenerateReactorKeys() {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/reactor").put().go();
    }

    public ClientResponse<RegistrationResponse, Errors> register(UUID userId, RegistrationRequest request) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> reindex(ReindexRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/system/reindex").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> removeUserFromFamily(UUID familyId, UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/family").urlSegment((Object)familyId).urlSegment((Object)userId).delete().go();
    }

    public ClientResponse<VerifyEmailResponse, Errors> resendEmailVerification(String email) {
        return this.start(VerifyEmailResponse.class, Errors.class).uri("/api/user/verify-email").urlParameter("email", email).put().go();
    }

    public ClientResponse<VerifyEmailResponse, Errors> resendEmailVerificationWithApplicationTemplate(UUID applicationId, String email) {
        return this.start(VerifyEmailResponse.class, Errors.class).uri("/api/user/verify-email").urlParameter("applicationId", (Object)applicationId).urlParameter("email", email).put().go();
    }

    public ClientResponse<VerifyRegistrationResponse, Errors> resendRegistrationVerification(String email, UUID applicationId) {
        return this.start(VerifyRegistrationResponse.class, Errors.class).uri("/api/user/verify-registration").urlParameter("email", email).urlParameter("applicationId", (Object)applicationId).put().go();
    }

    public ClientResponse<APIKeyResponse, Errors> retrieveAPIKey(UUID keyId) {
        return this.start(APIKeyResponse.class, Errors.class).uri("/api/api-key").urlSegment((Object)keyId).get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveAction(UUID actionId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlSegment((Object)actionId).get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveActions(UUID userId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveActionsPreventingLogin(UUID userId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlParameter("userId", (Object)userId).urlParameter("preventingLogin", (Object)true).get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveActiveActions(UUID userId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlParameter("userId", (Object)userId).urlParameter("active", (Object)true).get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveApplication(UUID applicationId) {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").urlSegment((Object)applicationId).get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveApplications() {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").get().go();
    }

    public ClientResponse<AuditLogResponse, Errors> retrieveAuditLog(Integer auditLogId) {
        return this.start(AuditLogResponse.class, Errors.class).uri("/api/system/audit-log").urlSegment((Object)auditLogId).get().go();
    }

    public ClientResponse<ConnectorResponse, Void> retrieveConnector(UUID connectorId) {
        return this.start(ConnectorResponse.class, Void.TYPE).uri("/api/connector").urlSegment((Object)connectorId).get().go();
    }

    public ClientResponse<ConnectorResponse, Void> retrieveConnectors() {
        return this.start(ConnectorResponse.class, Void.TYPE).uri("/api/connector").get().go();
    }

    public ClientResponse<ConsentResponse, Void> retrieveConsent(UUID consentId) {
        return this.start(ConsentResponse.class, Void.TYPE).uri("/api/consent").urlSegment((Object)consentId).get().go();
    }

    public ClientResponse<ConsentResponse, Void> retrieveConsents() {
        return this.start(ConsentResponse.class, Void.TYPE).uri("/api/consent").get().go();
    }

    public ClientResponse<DailyActiveUserReportResponse, Errors> retrieveDailyActiveReport(UUID applicationId, long start, long end) {
        return this.start(DailyActiveUserReportResponse.class, Errors.class).uri("/api/report/daily-active-user").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<EmailTemplateResponse, Void> retrieveEmailTemplate(UUID emailTemplateId) {
        return this.start(EmailTemplateResponse.class, Void.TYPE).uri("/api/email/template").urlSegment((Object)emailTemplateId).get().go();
    }

    public ClientResponse<PreviewResponse, Errors> retrieveEmailTemplatePreview(PreviewRequest request) {
        return this.start(PreviewResponse.class, Errors.class).uri("/api/email/template/preview").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EmailTemplateResponse, Void> retrieveEmailTemplates() {
        return this.start(EmailTemplateResponse.class, Void.TYPE).uri("/api/email/template").get().go();
    }

    public ClientResponse<EntityResponse, Errors> retrieveEntity(UUID entityId) {
        return this.start(EntityResponse.class, Errors.class).uri("/api/entity").urlSegment((Object)entityId).get().go();
    }

    public ClientResponse<EntityGrantResponse, Errors> retrieveEntityGrant(UUID entityId, UUID recipientEntityId, UUID userId) {
        return this.start(EntityGrantResponse.class, Errors.class).uri("/api/entity").urlSegment((Object)entityId).urlSegment((Object)"grant").urlParameter("recipientEntityId", (Object)recipientEntityId).urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> retrieveEntityType(UUID entityTypeId) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).get().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> retrieveEntityTypes() {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").get().go();
    }

    public ClientResponse<EventLogResponse, Errors> retrieveEventLog(Integer eventLogId) {
        return this.start(EventLogResponse.class, Errors.class).uri("/api/system/event-log").urlSegment((Object)eventLogId).get().go();
    }

    public ClientResponse<FamilyResponse, Void> retrieveFamilies(UUID userId) {
        return this.start(FamilyResponse.class, Void.TYPE).uri("/api/user/family").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<FamilyResponse, Void> retrieveFamilyMembersByFamilyId(UUID familyId) {
        return this.start(FamilyResponse.class, Void.TYPE).uri("/api/user/family").urlSegment((Object)familyId).get().go();
    }

    public ClientResponse<FormResponse, Void> retrieveForm(UUID formId) {
        return this.start(FormResponse.class, Void.TYPE).uri("/api/form").urlSegment((Object)formId).get().go();
    }

    public ClientResponse<FormFieldResponse, Void> retrieveFormField(UUID fieldId) {
        return this.start(FormFieldResponse.class, Void.TYPE).uri("/api/form/field").urlSegment((Object)fieldId).get().go();
    }

    public ClientResponse<FormFieldResponse, Void> retrieveFormFields() {
        return this.start(FormFieldResponse.class, Void.TYPE).uri("/api/form/field").get().go();
    }

    public ClientResponse<FormResponse, Void> retrieveForms() {
        return this.start(FormResponse.class, Void.TYPE).uri("/api/form").get().go();
    }

    public ClientResponse<GroupResponse, Errors> retrieveGroup(UUID groupId) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).get().go();
    }

    public ClientResponse<GroupResponse, Void> retrieveGroups() {
        return this.start(GroupResponse.class, Void.TYPE).uri("/api/group").get().go();
    }

    public ClientResponse<IPAccessControlListResponse, Void> retrieveIPAccessControlList(UUID ipAccessControlListId) {
        return this.start(IPAccessControlListResponse.class, Void.TYPE).uri("/api/ip-acl").urlSegment((Object)ipAccessControlListId).get().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> retrieveIdentityProvider(UUID identityProviderId) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).get().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> retrieveIdentityProviderByType(IdentityProviderType type) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlParameter("type", (Object)type).get().go();
    }

    public ClientResponse<IdentityProviderResponse, Void> retrieveIdentityProviders() {
        return this.start(IdentityProviderResponse.class, Void.TYPE).uri("/api/identity-provider").get().go();
    }

    public ClientResponse<ActionResponse, Errors> retrieveInactiveActions(UUID userId) {
        return this.start(ActionResponse.class, Errors.class).uri("/api/user/action").urlParameter("userId", (Object)userId).urlParameter("active", (Object)false).get().go();
    }

    public ClientResponse<ApplicationResponse, Void> retrieveInactiveApplications() {
        return this.start(ApplicationResponse.class, Void.TYPE).uri("/api/application").urlParameter("inactive", (Object)true).get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveInactiveUserActions() {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").urlParameter("inactive", (Object)true).get().go();
    }

    public ClientResponse<IntegrationResponse, Void> retrieveIntegration() {
        return this.start(IntegrationResponse.class, Void.TYPE).uri("/api/integration").get().go();
    }

    public ClientResponse<PublicKeyResponse, Void> retrieveJWTPublicKey(String keyId) {
        return this.startAnonymous(PublicKeyResponse.class, Void.TYPE).uri("/api/jwt/public-key").urlParameter("kid", keyId).get().go();
    }

    public ClientResponse<PublicKeyResponse, Void> retrieveJWTPublicKeyByApplicationId(String applicationId) {
        return this.startAnonymous(PublicKeyResponse.class, Void.TYPE).uri("/api/jwt/public-key").urlParameter("applicationId", applicationId).get().go();
    }

    public ClientResponse<PublicKeyResponse, Void> retrieveJWTPublicKeys() {
        return this.startAnonymous(PublicKeyResponse.class, Void.TYPE).uri("/api/jwt/public-key").get().go();
    }

    public ClientResponse<JWKSResponse, Void> retrieveJsonWebKeySet() {
        return this.startAnonymous(JWKSResponse.class, Void.TYPE).uri("/.well-known/jwks.json").get().go();
    }

    public ClientResponse<KeyResponse, Errors> retrieveKey(UUID keyId) {
        return this.start(KeyResponse.class, Errors.class).uri("/api/key").urlSegment((Object)keyId).get().go();
    }

    public ClientResponse<KeyResponse, Void> retrieveKeys() {
        return this.start(KeyResponse.class, Void.TYPE).uri("/api/key").get().go();
    }

    public ClientResponse<LambdaResponse, Errors> retrieveLambda(UUID lambdaId) {
        return this.start(LambdaResponse.class, Errors.class).uri("/api/lambda").urlSegment((Object)lambdaId).get().go();
    }

    public ClientResponse<LambdaResponse, Void> retrieveLambdas() {
        return this.start(LambdaResponse.class, Void.TYPE).uri("/api/lambda").get().go();
    }

    public ClientResponse<LambdaResponse, Void> retrieveLambdasByType(LambdaType type) {
        return this.start(LambdaResponse.class, Void.TYPE).uri("/api/lambda").urlParameter("type", (Object)type).get().go();
    }

    public ClientResponse<LoginReportResponse, Errors> retrieveLoginReport(UUID applicationId, long start, long end) {
        return this.start(LoginReportResponse.class, Errors.class).uri("/api/report/login").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<MessageTemplateResponse, Void> retrieveMessageTemplate(UUID messageTemplateId) {
        return this.start(MessageTemplateResponse.class, Void.TYPE).uri("/api/message/template").urlSegment((Object)messageTemplateId).get().go();
    }

    public ClientResponse<PreviewMessageTemplateResponse, Errors> retrieveMessageTemplatePreview(PreviewMessageTemplateRequest request) {
        return this.start(PreviewMessageTemplateResponse.class, Errors.class).uri("/api/message/template/preview").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<MessageTemplateResponse, Void> retrieveMessageTemplates() {
        return this.start(MessageTemplateResponse.class, Void.TYPE).uri("/api/message/template").get().go();
    }

    public ClientResponse<MessengerResponse, Void> retrieveMessenger(UUID messengerId) {
        return this.start(MessengerResponse.class, Void.TYPE).uri("/api/messenger").urlSegment((Object)messengerId).get().go();
    }

    public ClientResponse<MessengerResponse, Void> retrieveMessengers() {
        return this.start(MessengerResponse.class, Void.TYPE).uri("/api/messenger").get().go();
    }

    public ClientResponse<MonthlyActiveUserReportResponse, Errors> retrieveMonthlyActiveReport(UUID applicationId, long start, long end) {
        return this.start(MonthlyActiveUserReportResponse.class, Errors.class).uri("/api/report/monthly-active-user").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<ApplicationOAuthScopeResponse, Errors> retrieveOAuthScope(UUID applicationId, UUID scopeId) {
        return this.start(ApplicationOAuthScopeResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"scope").urlSegment((Object)scopeId).get().go();
    }

    public ClientResponse<OAuthConfigurationResponse, Errors> retrieveOauthConfiguration(UUID applicationId) {
        return this.start(OAuthConfigurationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"oauth-configuration").get().go();
    }

    public ClientResponse<OpenIdConfiguration, Void> retrieveOpenIdConfiguration() {
        return this.startAnonymous(OpenIdConfiguration.class, Void.TYPE).uri("/.well-known/openid-configuration").get().go();
    }

    public ClientResponse<PasswordValidationRulesResponse, Void> retrievePasswordValidationRules() {
        return this.startAnonymous(PasswordValidationRulesResponse.class, Void.TYPE).uri("/api/tenant/password-validation-rules").get().go();
    }

    public ClientResponse<PasswordValidationRulesResponse, Void> retrievePasswordValidationRulesWithTenantId(UUID tenantId) {
        return this.startAnonymous(PasswordValidationRulesResponse.class, Void.TYPE).uri("/api/tenant/password-validation-rules").urlSegment((Object)tenantId).get().go();
    }

    public ClientResponse<PendingResponse, Errors> retrievePendingChildren(String parentEmail) {
        return this.start(PendingResponse.class, Errors.class).uri("/api/user/family/pending").urlParameter("parentEmail", parentEmail).get().go();
    }

    public ClientResponse<IdentityProviderPendingLinkResponse, Errors> retrievePendingLink(String pendingLinkId, UUID userId) {
        return this.start(IdentityProviderPendingLinkResponse.class, Errors.class).uri("/api/identity-provider/link/pending").urlSegment((Object)pendingLinkId).urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<ReactorMetricsResponse, Void> retrieveReactorMetrics() {
        return this.start(ReactorMetricsResponse.class, Void.TYPE).uri("/api/reactor/metrics").get().go();
    }

    public ClientResponse<ReactorResponse, Void> retrieveReactorStatus() {
        return this.start(ReactorResponse.class, Void.TYPE).uri("/api/reactor").get().go();
    }

    public ClientResponse<RecentLoginResponse, Errors> retrieveRecentLogins(int offset, Integer limit) {
        return this.start(RecentLoginResponse.class, Errors.class).uri("/api/user/recent-login").urlParameter("offset", (Object)offset).urlParameter("limit", (Object)limit).get().go();
    }

    public ClientResponse<RefreshTokenResponse, Errors> retrieveRefreshTokenById(UUID tokenId) {
        return this.start(RefreshTokenResponse.class, Errors.class).uri("/api/jwt/refresh").urlSegment((Object)tokenId).get().go();
    }

    public ClientResponse<RefreshTokenResponse, Errors> retrieveRefreshTokens(UUID userId) {
        return this.start(RefreshTokenResponse.class, Errors.class).uri("/api/jwt/refresh").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<RegistrationResponse, Errors> retrieveRegistration(UUID userId, UUID applicationId) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).urlSegment((Object)applicationId).get().go();
    }

    public ClientResponse<RegistrationReportResponse, Errors> retrieveRegistrationReport(UUID applicationId, long start, long end) {
        return this.start(RegistrationReportResponse.class, Errors.class).uri("/api/report/registration").urlParameter("applicationId", (Object)applicationId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<Void, Errors> retrieveReindexStatus() {
        return this.start(Void.TYPE, Errors.class).uri("/api/system/reindex").get().go();
    }

    public ClientResponse<SystemConfigurationResponse, Void> retrieveSystemConfiguration() {
        return this.start(SystemConfigurationResponse.class, Void.TYPE).uri("/api/system-configuration").get().go();
    }

    public ClientResponse<Void, Void> retrieveSystemHealth() {
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/api/health").get().go();
    }

    public ClientResponse<StatusResponse, Void> retrieveSystemStatus() {
        return this.startAnonymous(StatusResponse.class, Void.TYPE).uri("/api/status").get().go();
    }

    public ClientResponse<StatusResponse, Void> retrieveSystemStatusUsingAPIKey() {
        return this.start(StatusResponse.class, Void.TYPE).uri("/api/status").get().go();
    }

    public ClientResponse<TenantResponse, Errors> retrieveTenant(UUID tenantId) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).get().go();
    }

    public ClientResponse<TenantResponse, Void> retrieveTenants() {
        return this.start(TenantResponse.class, Void.TYPE).uri("/api/tenant").get().go();
    }

    public ClientResponse<ThemeResponse, Errors> retrieveTheme(UUID themeId) {
        return this.start(ThemeResponse.class, Errors.class).uri("/api/theme").urlSegment((Object)themeId).get().go();
    }

    public ClientResponse<ThemeResponse, Void> retrieveThemes() {
        return this.start(ThemeResponse.class, Void.TYPE).uri("/api/theme").get().go();
    }

    public ClientResponse<TotalsReportResponse, Void> retrieveTotalReport() {
        return this.start(TotalsReportResponse.class, Void.TYPE).uri("/api/report/totals").get().go();
    }

    public ClientResponse<TwoFactorRecoveryCodeResponse, Errors> retrieveTwoFactorRecoveryCodes(UUID userId) {
        return this.start(TwoFactorRecoveryCodeResponse.class, Errors.class).uri("/api/user/two-factor/recovery-code").urlSegment((Object)userId).get().go();
    }

    public ClientResponse<TwoFactorStatusResponse, Errors> retrieveTwoFactorStatus(UUID userId, UUID applicationId, String twoFactorTrustId) {
        return this.start(TwoFactorStatusResponse.class, Errors.class).uri("/api/two-factor/status").urlParameter("userId", (Object)userId).urlParameter("applicationId", (Object)applicationId).urlSegment((Object)twoFactorTrustId).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUser(UUID userId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveUserAction(UUID userActionId) {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").urlSegment((Object)userActionId).get().go();
    }

    public ClientResponse<UserActionReasonResponse, Void> retrieveUserActionReason(UUID userActionReasonId) {
        return this.start(UserActionReasonResponse.class, Void.TYPE).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).get().go();
    }

    public ClientResponse<UserActionReasonResponse, Void> retrieveUserActionReasons() {
        return this.start(UserActionReasonResponse.class, Void.TYPE).uri("/api/user-action-reason").get().go();
    }

    public ClientResponse<UserActionResponse, Void> retrieveUserActions() {
        return this.start(UserActionResponse.class, Void.TYPE).uri("/api/user-action").get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByChangePasswordId(String changePasswordId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("changePasswordId", changePasswordId).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByEmail(String email) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("email", email).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByLoginId(String loginId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("loginId", loginId).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByUsername(String username) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("username", username).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserByVerificationId(String verificationId) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlParameter("verificationId", verificationId).get().go();
    }

    public ClientResponse<Void, Void> retrieveUserCode(String client_id, String client_secret, String user_code) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("client_id", Arrays.asList(client_id));
        parameters.put("client_secret", Arrays.asList(client_secret));
        parameters.put("user_code", Arrays.asList(user_code));
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/oauth2/device/user-code").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).get().go();
    }

    public ClientResponse<Void, Void> retrieveUserCodeUsingAPIKey(String user_code) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("user_code", Arrays.asList(user_code));
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/oauth2/device/user-code").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(parameters)).get().go();
    }

    public ClientResponse<UserCommentResponse, Errors> retrieveUserComments(UUID userId) {
        return this.start(UserCommentResponse.class, Errors.class).uri("/api/user/comment").urlSegment((Object)userId).get().go();
    }

    public ClientResponse<UserConsentResponse, Void> retrieveUserConsent(UUID userConsentId) {
        return this.start(UserConsentResponse.class, Void.TYPE).uri("/api/user/consent").urlSegment((Object)userConsentId).get().go();
    }

    public ClientResponse<UserConsentResponse, Void> retrieveUserConsents(UUID userId) {
        return this.start(UserConsentResponse.class, Void.TYPE).uri("/api/user/consent").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<UserinfoResponse, OAuthError> retrieveUserInfoFromAccessToken(String encodedJWT) {
        return this.startAnonymous(UserinfoResponse.class, OAuthError.class).uri("/oauth2/userinfo").authorization("Bearer " + encodedJWT).get().go();
    }

    public ClientResponse<IdentityProviderLinkResponse, Errors> retrieveUserLink(UUID identityProviderId, String identityProviderUserId, UUID userId) {
        return this.start(IdentityProviderLinkResponse.class, Errors.class).uri("/api/identity-provider/link").urlParameter("identityProviderId", (Object)identityProviderId).urlParameter("identityProviderUserId", identityProviderUserId).urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<IdentityProviderLinkResponse, Errors> retrieveUserLinksByUserId(UUID identityProviderId, UUID userId) {
        return this.start(IdentityProviderLinkResponse.class, Errors.class).uri("/api/identity-provider/link").urlParameter("identityProviderId", (Object)identityProviderId).urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<LoginReportResponse, Errors> retrieveUserLoginReport(UUID applicationId, UUID userId, long start, long end) {
        return this.start(LoginReportResponse.class, Errors.class).uri("/api/report/login").urlParameter("applicationId", (Object)applicationId).urlParameter("userId", (Object)userId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<LoginReportResponse, Errors> retrieveUserLoginReportByLoginId(UUID applicationId, String loginId, long start, long end) {
        return this.start(LoginReportResponse.class, Errors.class).uri("/api/report/login").urlParameter("applicationId", (Object)applicationId).urlParameter("loginId", loginId).urlParameter("start", (Object)start).urlParameter("end", (Object)end).get().go();
    }

    public ClientResponse<RecentLoginResponse, Errors> retrieveUserRecentLogins(UUID userId, int offset, Integer limit) {
        return this.start(RecentLoginResponse.class, Errors.class).uri("/api/user/recent-login").urlParameter("userId", (Object)userId).urlParameter("offset", (Object)offset).urlParameter("limit", (Object)limit).get().go();
    }

    public ClientResponse<UserResponse, Errors> retrieveUserUsingJWT(String encodedJWT) {
        return this.startAnonymous(UserResponse.class, Errors.class).uri("/api/user").authorization("Bearer " + encodedJWT).get().go();
    }

    public ClientResponse<VersionResponse, Errors> retrieveVersion() {
        return this.start(VersionResponse.class, Errors.class).uri("/api/system/version").get().go();
    }

    public ClientResponse<WebAuthnCredentialResponse, Errors> retrieveWebAuthnCredential(UUID id) {
        return this.start(WebAuthnCredentialResponse.class, Errors.class).uri("/api/webauthn").urlSegment((Object)id).get().go();
    }

    public ClientResponse<WebAuthnCredentialResponse, Errors> retrieveWebAuthnCredentialsForUser(UUID userId) {
        return this.start(WebAuthnCredentialResponse.class, Errors.class).uri("/api/webauthn").urlParameter("userId", (Object)userId).get().go();
    }

    public ClientResponse<WebhookResponse, Void> retrieveWebhook(UUID webhookId) {
        return this.start(WebhookResponse.class, Void.TYPE).uri("/api/webhook").urlSegment((Object)webhookId).get().go();
    }

    public ClientResponse<WebhookAttemptLogResponse, Errors> retrieveWebhookAttemptLog(UUID webhookAttemptLogId) {
        return this.start(WebhookAttemptLogResponse.class, Errors.class).uri("/api/system/webhook-attempt-log").urlSegment((Object)webhookAttemptLogId).get().go();
    }

    public ClientResponse<WebhookEventLogResponse, Errors> retrieveWebhookEventLog(UUID webhookEventLogId) {
        return this.start(WebhookEventLogResponse.class, Errors.class).uri("/api/system/webhook-event-log").urlSegment((Object)webhookEventLogId).get().go();
    }

    public ClientResponse<WebhookResponse, Void> retrieveWebhooks() {
        return this.start(WebhookResponse.class, Void.TYPE).uri("/api/webhook").get().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshToken(String token, UUID userId, UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("token", token).urlParameter("userId", (Object)userId).urlParameter("applicationId", (Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokenById(UUID tokenId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlSegment((Object)tokenId).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokenByToken(String token) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("token", token).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokensByApplicationId(UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("applicationId", (Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokensByUserId(UUID userId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("userId", (Object)userId).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokensByUserIdForApplication(UUID userId, UUID applicationId) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").urlParameter("userId", (Object)userId).urlParameter("applicationId", (Object)applicationId).delete().go();
    }

    public ClientResponse<Void, Errors> revokeRefreshTokensWithRequest(RefreshTokenRevokeRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/jwt/refresh").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).delete().go();
    }

    public ClientResponse<Void, Void> revokeUserConsent(UUID userConsentId) {
        return this.start(Void.TYPE, Void.TYPE).uri("/api/user/consent").urlSegment((Object)userConsentId).delete().go();
    }

    public ClientResponse<ApplicationSearchResponse, Errors> searchApplications(ApplicationSearchRequest request) {
        return this.start(ApplicationSearchResponse.class, Errors.class).uri("/api/application/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<AuditLogSearchResponse, Errors> searchAuditLogs(AuditLogSearchRequest request) {
        return this.start(AuditLogSearchResponse.class, Errors.class).uri("/api/system/audit-log/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ConsentSearchResponse, Errors> searchConsents(ConsentSearchRequest request) {
        return this.start(ConsentSearchResponse.class, Errors.class).uri("/api/consent/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EmailTemplateSearchResponse, Errors> searchEmailTemplates(EmailTemplateSearchRequest request) {
        return this.start(EmailTemplateSearchResponse.class, Errors.class).uri("/api/email/template/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntitySearchResponse, Errors> searchEntities(EntitySearchRequest request) {
        return this.start(EntitySearchResponse.class, Errors.class).uri("/api/entity/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntitySearchResponse, Errors> searchEntitiesByIds(Collection<UUID> ids) {
        return this.start(EntitySearchResponse.class, Errors.class).uri("/api/entity/search").urlParameter("ids", ids).get().go();
    }

    public ClientResponse<EntityGrantSearchResponse, Errors> searchEntityGrants(EntityGrantSearchRequest request) {
        return this.start(EntityGrantSearchResponse.class, Errors.class).uri("/api/entity/grant/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EntityTypeSearchResponse, Errors> searchEntityTypes(EntityTypeSearchRequest request) {
        return this.start(EntityTypeSearchResponse.class, Errors.class).uri("/api/entity/type/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<EventLogSearchResponse, Errors> searchEventLogs(EventLogSearchRequest request) {
        return this.start(EventLogSearchResponse.class, Errors.class).uri("/api/system/event-log/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<GroupMemberSearchResponse, Errors> searchGroupMembers(GroupMemberSearchRequest request) {
        return this.start(GroupMemberSearchResponse.class, Errors.class).uri("/api/group/member/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<GroupSearchResponse, Errors> searchGroups(GroupSearchRequest request) {
        return this.start(GroupSearchResponse.class, Errors.class).uri("/api/group/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IPAccessControlListSearchResponse, Errors> searchIPAccessControlLists(IPAccessControlListSearchRequest request) {
        return this.start(IPAccessControlListSearchResponse.class, Errors.class).uri("/api/ip-acl/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IdentityProviderSearchResponse, Errors> searchIdentityProviders(IdentityProviderSearchRequest request) {
        return this.start(IdentityProviderSearchResponse.class, Errors.class).uri("/api/identity-provider/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<KeySearchResponse, Errors> searchKeys(KeySearchRequest request) {
        return this.start(KeySearchResponse.class, Errors.class).uri("/api/key/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LambdaSearchResponse, Errors> searchLambdas(LambdaSearchRequest request) {
        return this.start(LambdaSearchResponse.class, Errors.class).uri("/api/lambda/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LoginRecordSearchResponse, Errors> searchLoginRecords(LoginRecordSearchRequest request) {
        return this.start(LoginRecordSearchResponse.class, Errors.class).uri("/api/system/login-record/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<TenantSearchResponse, Errors> searchTenants(TenantSearchRequest request) {
        return this.start(TenantSearchResponse.class, Errors.class).uri("/api/tenant/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<ThemeSearchResponse, Errors> searchThemes(ThemeSearchRequest request) {
        return this.start(ThemeSearchResponse.class, Errors.class).uri("/api/theme/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<UserCommentSearchResponse, Errors> searchUserComments(UserCommentSearchRequest request) {
        return this.start(UserCommentSearchResponse.class, Errors.class).uri("/api/user/comment/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<SearchResponse, Errors> searchUsers(Collection<UUID> ids) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").urlParameter("ids", ids).get().go();
    }

    public ClientResponse<SearchResponse, Errors> searchUsersByIds(Collection<UUID> ids) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").urlParameter("ids", ids).get().go();
    }

    public ClientResponse<SearchResponse, Errors> searchUsersByQuery(SearchRequest request) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<SearchResponse, Errors> searchUsersByQueryString(SearchRequest request) {
        return this.start(SearchResponse.class, Errors.class).uri("/api/user/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebhookEventLogSearchResponse, Errors> searchWebhookEventLogs(WebhookEventLogSearchRequest request) {
        return this.start(WebhookEventLogSearchResponse.class, Errors.class).uri("/api/system/webhook-event-log/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebhookSearchResponse, Errors> searchWebhooks(WebhookSearchRequest request) {
        return this.start(WebhookSearchResponse.class, Errors.class).uri("/api/webhook/search").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<SendResponse, Errors> sendEmail(UUID emailTemplateId, SendRequest request) {
        return this.start(SendResponse.class, Errors.class).uri("/api/email/send").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> sendFamilyRequestEmail(FamilyEmailRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/family/request").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> sendPasswordlessCode(PasswordlessSendRequest request) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/passwordless/send").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<Void, Errors> sendTwoFactorCode(TwoFactorSendRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/two-factor/send").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> sendTwoFactorCodeForEnableDisable(TwoFactorSendRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/two-factor/send").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<Void, Errors> sendTwoFactorCodeForLogin(String twoFactorId) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/two-factor/send").urlSegment((Object)twoFactorId).post().go();
    }

    public ClientResponse<Void, Errors> sendTwoFactorCodeForLoginUsingMethod(String twoFactorId, TwoFactorSendRequest request) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/two-factor/send").urlSegment((Object)twoFactorId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<IdentityProviderStartLoginResponse, Errors> startIdentityProviderLogin(IdentityProviderStartLoginRequest request) {
        return this.start(IdentityProviderStartLoginResponse.class, Errors.class).uri("/api/identity-provider/start").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<PasswordlessStartResponse, Errors> startPasswordlessLogin(PasswordlessStartRequest request) {
        return this.start(PasswordlessStartResponse.class, Errors.class).uri("/api/passwordless/start").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<TwoFactorStartResponse, Errors> startTwoFactorLogin(TwoFactorStartRequest request) {
        return this.start(TwoFactorStartResponse.class, Errors.class).uri("/api/two-factor/start").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebAuthnStartResponse, Errors> startWebAuthnLogin(WebAuthnStartRequest request) {
        return this.start(WebAuthnStartResponse.class, Errors.class).uri("/api/webauthn/start").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<WebAuthnRegisterStartResponse, Errors> startWebAuthnRegistration(WebAuthnRegisterStartRequest request) {
        return this.start(WebAuthnRegisterStartResponse.class, Errors.class).uri("/api/webauthn/register/start").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<LoginResponse, Errors> twoFactorLogin(TwoFactorLoginRequest request) {
        return this.startAnonymous(LoginResponse.class, Errors.class).uri("/api/two-factor/login").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<APIKeyResponse, Errors> updateAPIKey(UUID apiKeyId, APIKeyRequest request) {
        return this.start(APIKeyResponse.class, Errors.class).uri("/api/api-key").urlSegment((Object)apiKeyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ApplicationResponse, Errors> updateApplication(UUID applicationId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ApplicationResponse, Errors> updateApplicationRole(UUID applicationId, UUID roleId, ApplicationRequest request) {
        return this.start(ApplicationResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"role").urlSegment((Object)roleId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ConnectorResponse, Errors> updateConnector(UUID connectorId, ConnectorRequest request) {
        return this.start(ConnectorResponse.class, Errors.class).uri("/api/connector").urlSegment((Object)connectorId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ConsentResponse, Errors> updateConsent(UUID consentId, ConsentRequest request) {
        return this.start(ConsentResponse.class, Errors.class).uri("/api/consent").urlSegment((Object)consentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<EmailTemplateResponse, Errors> updateEmailTemplate(UUID emailTemplateId, EmailTemplateRequest request) {
        return this.start(EmailTemplateResponse.class, Errors.class).uri("/api/email/template").urlSegment((Object)emailTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<EntityResponse, Errors> updateEntity(UUID entityId, EntityRequest request) {
        return this.start(EntityResponse.class, Errors.class).uri("/api/entity").urlSegment((Object)entityId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> updateEntityType(UUID entityTypeId, EntityTypeRequest request) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<EntityTypeResponse, Errors> updateEntityTypePermission(UUID entityTypeId, UUID permissionId, EntityTypeRequest request) {
        return this.start(EntityTypeResponse.class, Errors.class).uri("/api/entity/type").urlSegment((Object)entityTypeId).urlSegment((Object)"permission").urlSegment((Object)permissionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<FormResponse, Errors> updateForm(UUID formId, FormRequest request) {
        return this.start(FormResponse.class, Errors.class).uri("/api/form").urlSegment((Object)formId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<FormFieldResponse, Errors> updateFormField(UUID fieldId, FormFieldRequest request) {
        return this.start(FormFieldResponse.class, Errors.class).uri("/api/form/field").urlSegment((Object)fieldId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<GroupResponse, Errors> updateGroup(UUID groupId, GroupRequest request) {
        return this.start(GroupResponse.class, Errors.class).uri("/api/group").urlSegment((Object)groupId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<MemberResponse, Errors> updateGroupMembers(MemberRequest request) {
        return this.start(MemberResponse.class, Errors.class).uri("/api/group/member").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<IPAccessControlListResponse, Errors> updateIPAccessControlList(UUID accessControlListId, IPAccessControlListRequest request) {
        return this.start(IPAccessControlListResponse.class, Errors.class).uri("/api/ip-acl").urlSegment((Object)accessControlListId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<IdentityProviderResponse, Errors> updateIdentityProvider(UUID identityProviderId, IdentityProviderRequest request) {
        return this.start(IdentityProviderResponse.class, Errors.class).uri("/api/identity-provider").urlSegment((Object)identityProviderId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<IntegrationResponse, Errors> updateIntegrations(IntegrationRequest request) {
        return this.start(IntegrationResponse.class, Errors.class).uri("/api/integration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<KeyResponse, Errors> updateKey(UUID keyId, KeyRequest request) {
        return this.start(KeyResponse.class, Errors.class).uri("/api/key").urlSegment((Object)keyId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<LambdaResponse, Errors> updateLambda(UUID lambdaId, LambdaRequest request) {
        return this.start(LambdaResponse.class, Errors.class).uri("/api/lambda").urlSegment((Object)lambdaId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<MessageTemplateResponse, Errors> updateMessageTemplate(UUID messageTemplateId, MessageTemplateRequest request) {
        return this.start(MessageTemplateResponse.class, Errors.class).uri("/api/message/template").urlSegment((Object)messageTemplateId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<MessengerResponse, Errors> updateMessenger(UUID messengerId, MessengerRequest request) {
        return this.start(MessengerResponse.class, Errors.class).uri("/api/messenger").urlSegment((Object)messengerId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ApplicationOAuthScopeResponse, Errors> updateOAuthScope(UUID applicationId, UUID scopeId, ApplicationOAuthScopeRequest request) {
        return this.start(ApplicationOAuthScopeResponse.class, Errors.class).uri("/api/application").urlSegment((Object)applicationId).urlSegment((Object)"scope").urlSegment((Object)scopeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<RegistrationResponse, Errors> updateRegistration(UUID userId, RegistrationRequest request) {
        return this.start(RegistrationResponse.class, Errors.class).uri("/api/user/registration").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<SystemConfigurationResponse, Errors> updateSystemConfiguration(SystemConfigurationRequest request) {
        return this.start(SystemConfigurationResponse.class, Errors.class).uri("/api/system-configuration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<TenantResponse, Errors> updateTenant(UUID tenantId, TenantRequest request) {
        return this.start(TenantResponse.class, Errors.class).uri("/api/tenant").urlSegment((Object)tenantId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<ThemeResponse, Errors> updateTheme(UUID themeId, ThemeRequest request) {
        return this.start(ThemeResponse.class, Errors.class).uri("/api/theme").urlSegment((Object)themeId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<UserResponse, Errors> updateUser(UUID userId, UserRequest request) {
        return this.start(UserResponse.class, Errors.class).uri("/api/user").urlSegment((Object)userId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<UserActionResponse, Errors> updateUserAction(UUID userActionId, UserActionRequest request) {
        return this.start(UserActionResponse.class, Errors.class).uri("/api/user-action").urlSegment((Object)userActionId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<UserActionReasonResponse, Errors> updateUserActionReason(UUID userActionReasonId, UserActionReasonRequest request) {
        return this.start(UserActionReasonResponse.class, Errors.class).uri("/api/user-action-reason").urlSegment((Object)userActionReasonId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<UserConsentResponse, Errors> updateUserConsent(UUID userConsentId, UserConsentRequest request) {
        return this.start(UserConsentResponse.class, Errors.class).uri("/api/user/consent").urlSegment((Object)userConsentId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<WebhookResponse, Errors> updateWebhook(UUID webhookId, WebhookRequest request) {
        return this.start(WebhookResponse.class, Errors.class).uri("/api/webhook").urlSegment((Object)webhookId).bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).put().go();
    }

    public ClientResponse<Void, Errors> upsertEntityGrant(UUID entityId, EntityGrantRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/entity").urlSegment((Object)entityId).urlSegment((Object)"grant").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Void> validateDevice(String user_code, String client_id) {
        return this.startAnonymous(Void.TYPE, Void.TYPE).uri("/oauth2/device/validate").urlParameter("user_code", user_code).urlParameter("client_id", client_id).get().go();
    }

    public ClientResponse<ValidateResponse, Void> validateJWT(String encodedJWT) {
        return this.startAnonymous(ValidateResponse.class, Void.TYPE).uri("/api/jwt/validate").authorization("Bearer " + encodedJWT).get().go();
    }

    public ClientResponse<JWTVendResponse, Errors> vendJWT(JWTVendRequest request) {
        return this.start(JWTVendResponse.class, Errors.class).uri("/api/jwt/vend").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<Void, Errors> verifyEmail(String verificationId) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/verify-email").urlSegment((Object)verificationId).post().go();
    }

    public ClientResponse<Void, Errors> verifyEmailAddress(VerifyEmailRequest request) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/verify-email").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    public ClientResponse<Void, Errors> verifyEmailAddressByUserId(VerifyEmailRequest request) {
        return this.start(Void.TYPE, Errors.class).uri("/api/user/verify-email").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    @Deprecated
    public ClientResponse<Void, Errors> verifyRegistration(String verificationId) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/verify-registration").urlSegment((Object)verificationId).post().go();
    }

    public ClientResponse<Void, Errors> verifyUserRegistration(VerifyRegistrationRequest request) {
        return this.startAnonymous(Void.TYPE, Errors.class).uri("/api/user/verify-registration").bodyHandler((RESTClient.BodyHandler)new JSONBodyHandler((Object)request, this.objectMapper())).post().go();
    }

    protected <T, U> RESTClient<T, U> start(Class<T> type, Class<U> errorType) {
        return this.startAnonymous(type, errorType).authorization(this.apiKey);
    }

    protected <T, U> RESTClient<T, U> startAnonymous(Class<T> type, Class<U> errorType) {
        RESTClient client = new RESTClient(type, errorType).successResponseHandler((RESTClient.ResponseHandler)(type != Void.TYPE ? new JSONResponseHandler(type, this.objectMapper()) : null)).errorResponseHandler((RESTClient.ResponseHandler)(errorType != Void.TYPE ? new JSONResponseHandler(errorType, this.objectMapper()) : null)).url(this.baseURL).connectTimeout(this.connectTimeout).readTimeout(this.readTimeout);
        if (this.tenantId != null) {
            client.header(TENANT_ID_HEADER, this.tenantId);
        }
        return client;
    }

    private ObjectMapper objectMapper() {
        return this.customMapper != null ? this.customMapper : objectMapper;
    }
}

