/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.ApplicationAccessControlConfiguration;
import io.fusionauth.domain.ApplicationExternalIdentifierConfiguration;
import io.fusionauth.domain.ApplicationFormConfiguration;
import io.fusionauth.domain.ApplicationMultiFactorConfiguration;
import io.fusionauth.domain.ApplicationOAuthScope;
import io.fusionauth.domain.ApplicationRegistrationDeletePolicy;
import io.fusionauth.domain.ApplicationRole;
import io.fusionauth.domain.ApplicationWebAuthnConfiguration;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CanonicalizationMethod;
import io.fusionauth.domain.CleanSpeakConfiguration;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.JWTConfiguration;
import io.fusionauth.domain.ObjectState;
import io.fusionauth.domain.RegistrationUnverifiedOptions;
import io.fusionauth.domain.Requirable;
import io.fusionauth.domain.SAMLv2IdPInitiatedLoginConfiguration;
import io.fusionauth.domain.Tenantable;
import io.fusionauth.domain.VerificationStrategy;
import io.fusionauth.domain.oauth2.OAuth2Configuration;
import io.fusionauth.domain.provider.LoginHintConfiguration;
import io.fusionauth.domain.util.Normalizer;
import java.lang.reflect.Field;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class Application
implements Buildable<Application>,
Tenantable {
    public static final UUID FUSIONAUTH_APP_ID = UUID.fromString("3c219e58-ed0e-4b18-ad48-f4f92793ae32");
    public ApplicationAccessControlConfiguration accessControlConfiguration = new ApplicationAccessControlConfiguration();
    @Deprecated
    public boolean active;
    public AuthenticationTokenConfiguration authenticationTokenConfiguration = new AuthenticationTokenConfiguration();
    public CleanSpeakConfiguration cleanSpeakConfiguration;
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public ApplicationEmailConfiguration emailConfiguration = new ApplicationEmailConfiguration();
    public ApplicationExternalIdentifierConfiguration externalIdentifierConfiguration = new ApplicationExternalIdentifierConfiguration();
    public ApplicationFormConfiguration formConfiguration = new ApplicationFormConfiguration();
    public UUID id;
    public ZonedDateTime insertInstant;
    @JsonIgnoreProperties(value={"refreshTokenRevocationPolicy"})
    public JWTConfiguration jwtConfiguration = new JWTConfiguration();
    public LambdaConfiguration lambdaConfiguration = new LambdaConfiguration();
    public ZonedDateTime lastUpdateInstant;
    public LoginConfiguration loginConfiguration = new LoginConfiguration();
    public ApplicationMultiFactorConfiguration multiFactorConfiguration = new ApplicationMultiFactorConfiguration();
    public String name;
    public OAuth2Configuration oauthConfiguration = new OAuth2Configuration();
    public PasswordlessConfiguration passwordlessConfiguration = new PasswordlessConfiguration();
    public RegistrationConfiguration registrationConfiguration = new RegistrationConfiguration();
    public ApplicationRegistrationDeletePolicy registrationDeletePolicy = new ApplicationRegistrationDeletePolicy();
    public List<ApplicationRole> roles = new ArrayList<ApplicationRole>();
    public SAMLv2Configuration samlv2Configuration = new SAMLv2Configuration();
    @JsonIgnoreProperties(value={"applicationId"})
    public List<ApplicationOAuthScope> scopes = new ArrayList<ApplicationOAuthScope>();
    public ObjectState state;
    public UUID tenantId;
    public UUID themeId;
    public RegistrationUnverifiedOptions unverified = new RegistrationUnverifiedOptions();
    public UUID verificationEmailTemplateId;
    public VerificationStrategy verificationStrategy;
    public boolean verifyRegistration;
    public ApplicationWebAuthnConfiguration webAuthnConfiguration = new ApplicationWebAuthnConfiguration();

    @JacksonConstructor
    public Application() {
    }

    public Application(Application other) {
        this.active = other.active;
        this.accessControlConfiguration = new ApplicationAccessControlConfiguration(other.accessControlConfiguration);
        this.authenticationTokenConfiguration = new AuthenticationTokenConfiguration(other.authenticationTokenConfiguration);
        if (other.cleanSpeakConfiguration != null) {
            this.cleanSpeakConfiguration = new CleanSpeakConfiguration(other.cleanSpeakConfiguration);
        }
        this.data.putAll(other.data);
        this.emailConfiguration = new ApplicationEmailConfiguration(other.emailConfiguration);
        this.externalIdentifierConfiguration = new ApplicationExternalIdentifierConfiguration(other.externalIdentifierConfiguration);
        this.formConfiguration = new ApplicationFormConfiguration(other.formConfiguration);
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.jwtConfiguration = new JWTConfiguration(other.jwtConfiguration);
        this.lambdaConfiguration = new LambdaConfiguration(other.lambdaConfiguration);
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.loginConfiguration = new LoginConfiguration(other.loginConfiguration);
        this.multiFactorConfiguration = new ApplicationMultiFactorConfiguration(other.multiFactorConfiguration);
        this.name = other.name;
        this.oauthConfiguration = new OAuth2Configuration(other.oauthConfiguration);
        this.passwordlessConfiguration = new PasswordlessConfiguration(other.passwordlessConfiguration);
        this.registrationConfiguration = new RegistrationConfiguration(other.registrationConfiguration);
        this.registrationDeletePolicy = new ApplicationRegistrationDeletePolicy(other.registrationDeletePolicy);
        this.roles.addAll(other.roles.stream().map(ApplicationRole::new).collect(Collectors.toList()));
        this.samlv2Configuration = new SAMLv2Configuration(other.samlv2Configuration);
        this.scopes.addAll(other.scopes.stream().map(ApplicationOAuthScope::new).collect(Collectors.toList()));
        this.state = other.state;
        this.tenantId = other.tenantId;
        this.themeId = other.themeId;
        this.unverified = new RegistrationUnverifiedOptions(other.unverified);
        this.verificationEmailTemplateId = other.verificationEmailTemplateId;
        this.verificationStrategy = other.verificationStrategy;
        this.verifyRegistration = other.verifyRegistration;
        this.webAuthnConfiguration = new ApplicationWebAuthnConfiguration(other.webAuthnConfiguration);
    }

    public Application(String name) {
        this.name = name;
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public Application(UUID id, String name, boolean active, CleanSpeakConfiguration cleanSpeakConfiguration, OAuth2Configuration oAuthConfiguration, ApplicationRole ... roles) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.cleanSpeakConfiguration = cleanSpeakConfiguration;
        this.oauthConfiguration = oAuthConfiguration;
        Collections.addAll(this.roles, roles);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application that = (Application)o;
        return this.verifyRegistration == that.verifyRegistration && Objects.equals(this.accessControlConfiguration, that.accessControlConfiguration) && Objects.equals(this.authenticationTokenConfiguration, that.authenticationTokenConfiguration) && Objects.equals(this.cleanSpeakConfiguration, that.cleanSpeakConfiguration) && Objects.equals(this.data, that.data) && Objects.equals(this.emailConfiguration, that.emailConfiguration) && Objects.equals(this.externalIdentifierConfiguration, that.externalIdentifierConfiguration) && Objects.equals(this.formConfiguration, that.formConfiguration) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.jwtConfiguration, that.jwtConfiguration) && Objects.equals(this.lambdaConfiguration, that.lambdaConfiguration) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && Objects.equals(this.loginConfiguration, that.loginConfiguration) && Objects.equals(this.multiFactorConfiguration, that.multiFactorConfiguration) && Objects.equals(this.name, that.name) && Objects.equals(this.oauthConfiguration, that.oauthConfiguration) && Objects.equals(this.passwordlessConfiguration, that.passwordlessConfiguration) && Objects.equals(this.registrationConfiguration, that.registrationConfiguration) && Objects.equals(this.registrationDeletePolicy, that.registrationDeletePolicy) && Objects.equals(this.roles, that.roles) && Objects.equals(this.samlv2Configuration, that.samlv2Configuration) && Objects.equals(this.scopes, that.scopes) && this.state == that.state && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.themeId, that.themeId) && Objects.equals(this.unverified, that.unverified) && Objects.equals(this.verificationEmailTemplateId, that.verificationEmailTemplateId) && Objects.equals(this.webAuthnConfiguration, that.webAuthnConfiguration) && this.verificationStrategy == that.verificationStrategy;
    }

    public boolean getActive() {
        return this.state == ObjectState.Active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.state = active ? ObjectState.Active : ObjectState.Inactive;
    }

    public ApplicationOAuthScope getOAuthScope(String name) {
        return this.scopes.stream().filter(s -> s.name.equals(name)).findFirst().orElse(null);
    }

    public ApplicationRole getRole(String name) {
        for (ApplicationRole role : this.roles) {
            if (!role.name.equals(name)) continue;
            return role;
        }
        return null;
    }

    @Override
    public UUID getTenantId() {
        return this.tenantId;
    }

    public boolean hasDefaultRole() {
        return this.roles.size() > 0 && this.roles.stream().anyMatch(r -> r.isDefault);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessControlConfiguration, this.authenticationTokenConfiguration, this.cleanSpeakConfiguration, this.data, this.emailConfiguration, this.externalIdentifierConfiguration, this.formConfiguration, this.id, this.insertInstant, this.jwtConfiguration, this.lambdaConfiguration, this.lastUpdateInstant, this.loginConfiguration, this.multiFactorConfiguration, this.name, this.oauthConfiguration, this.passwordlessConfiguration, this.registrationConfiguration, this.registrationDeletePolicy, this.roles, this.samlv2Configuration, this.scopes, this.state, this.tenantId, this.themeId, this.unverified, this.verificationEmailTemplateId, this.verificationStrategy, this.verifyRegistration, this.webAuthnConfiguration});
    }

    public void normalize() {
        this.name = Normalizer.trim(this.name);
        if (this.cleanSpeakConfiguration != null) {
            this.cleanSpeakConfiguration.normalize();
        }
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.normalize();
        }
        this.jwtConfiguration.refreshTokenRevocationPolicy = null;
        this.roles.forEach(ApplicationRole::normalize);
        this.scopes.forEach(ApplicationOAuthScope::normalize);
        if (this.multiFactorConfiguration.loginPolicy == null) {
            this.multiFactorConfiguration.trustPolicy = null;
        }
    }

    public Application secure() {
        if (this.oauthConfiguration != null) {
            this.oauthConfiguration.clientSecret = null;
        }
        return this;
    }

    public Application sortOAuthScopes() {
        this.scopes.sort(ApplicationOAuthScope::compareTo);
        return this;
    }

    public Application sortRoles() {
        this.roles.sort(ApplicationRole::compareTo);
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class AuthenticationTokenConfiguration
    extends Enableable {
        @JacksonConstructor
        public AuthenticationTokenConfiguration() {
        }

        public AuthenticationTokenConfiguration(AuthenticationTokenConfiguration other) {
            this.enabled = other.enabled;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class ApplicationEmailConfiguration
    implements Buildable<ApplicationEmailConfiguration> {
        @JsonIgnore
        public static List<String> EmailTemplateIdFieldNames = Arrays.stream(ApplicationEmailConfiguration.class.getDeclaredFields()).map(Field::getName).filter(name -> name.endsWith("EmailTemplateId")).sorted().collect(Collectors.toList());
        @JsonIgnore
        public static List<Field> EmailTemplateIdFields = Arrays.stream(ApplicationEmailConfiguration.class.getDeclaredFields()).filter(f -> f.getName().endsWith("EmailTemplateId")).sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
        public UUID emailUpdateEmailTemplateId;
        public UUID emailVerificationEmailTemplateId;
        public UUID emailVerifiedEmailTemplateId;
        public UUID forgotPasswordEmailTemplateId;
        public UUID loginIdInUseOnCreateEmailTemplateId;
        public UUID loginIdInUseOnUpdateEmailTemplateId;
        public UUID loginNewDeviceEmailTemplateId;
        public UUID loginSuspiciousEmailTemplateId;
        public UUID passwordResetSuccessEmailTemplateId;
        public UUID passwordUpdateEmailTemplateId;
        public UUID passwordlessEmailTemplateId;
        public UUID setPasswordEmailTemplateId;
        public UUID twoFactorMethodAddEmailTemplateId;
        public UUID twoFactorMethodRemoveEmailTemplateId;

        @JacksonConstructor
        public ApplicationEmailConfiguration() {
        }

        public ApplicationEmailConfiguration(ApplicationEmailConfiguration other) {
            this.emailUpdateEmailTemplateId = other.emailUpdateEmailTemplateId;
            this.emailVerificationEmailTemplateId = other.emailVerificationEmailTemplateId;
            this.emailVerifiedEmailTemplateId = other.emailVerifiedEmailTemplateId;
            this.forgotPasswordEmailTemplateId = other.forgotPasswordEmailTemplateId;
            this.loginIdInUseOnCreateEmailTemplateId = other.loginIdInUseOnCreateEmailTemplateId;
            this.loginIdInUseOnUpdateEmailTemplateId = other.loginIdInUseOnUpdateEmailTemplateId;
            this.loginNewDeviceEmailTemplateId = other.loginNewDeviceEmailTemplateId;
            this.loginSuspiciousEmailTemplateId = other.loginSuspiciousEmailTemplateId;
            this.passwordResetSuccessEmailTemplateId = other.passwordResetSuccessEmailTemplateId;
            this.passwordUpdateEmailTemplateId = other.passwordUpdateEmailTemplateId;
            this.passwordlessEmailTemplateId = other.passwordlessEmailTemplateId;
            this.setPasswordEmailTemplateId = other.setPasswordEmailTemplateId;
            this.twoFactorMethodAddEmailTemplateId = other.twoFactorMethodAddEmailTemplateId;
            this.twoFactorMethodRemoveEmailTemplateId = other.twoFactorMethodRemoveEmailTemplateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApplicationEmailConfiguration that = (ApplicationEmailConfiguration)o;
            return Objects.equals(this.emailUpdateEmailTemplateId, that.emailUpdateEmailTemplateId) && Objects.equals(this.emailVerificationEmailTemplateId, that.emailVerificationEmailTemplateId) && Objects.equals(this.emailVerifiedEmailTemplateId, that.emailVerifiedEmailTemplateId) && Objects.equals(this.forgotPasswordEmailTemplateId, that.forgotPasswordEmailTemplateId) && Objects.equals(this.loginIdInUseOnCreateEmailTemplateId, that.loginIdInUseOnCreateEmailTemplateId) && Objects.equals(this.loginIdInUseOnUpdateEmailTemplateId, that.loginIdInUseOnUpdateEmailTemplateId) && Objects.equals(this.loginNewDeviceEmailTemplateId, that.loginNewDeviceEmailTemplateId) && Objects.equals(this.loginSuspiciousEmailTemplateId, that.loginSuspiciousEmailTemplateId) && Objects.equals(this.passwordResetSuccessEmailTemplateId, that.passwordResetSuccessEmailTemplateId) && Objects.equals(this.passwordUpdateEmailTemplateId, that.passwordUpdateEmailTemplateId) && Objects.equals(this.passwordlessEmailTemplateId, that.passwordlessEmailTemplateId) && Objects.equals(this.setPasswordEmailTemplateId, that.setPasswordEmailTemplateId) && Objects.equals(this.twoFactorMethodAddEmailTemplateId, that.twoFactorMethodAddEmailTemplateId) && Objects.equals(this.twoFactorMethodRemoveEmailTemplateId, that.twoFactorMethodRemoveEmailTemplateId);
        }

        public int hashCode() {
            return Objects.hash(this.emailUpdateEmailTemplateId, this.emailVerificationEmailTemplateId, this.emailVerifiedEmailTemplateId, this.forgotPasswordEmailTemplateId, this.loginIdInUseOnCreateEmailTemplateId, this.loginIdInUseOnUpdateEmailTemplateId, this.loginNewDeviceEmailTemplateId, this.loginSuspiciousEmailTemplateId, this.passwordResetSuccessEmailTemplateId, this.passwordUpdateEmailTemplateId, this.passwordlessEmailTemplateId, this.setPasswordEmailTemplateId, this.twoFactorMethodAddEmailTemplateId, this.twoFactorMethodRemoveEmailTemplateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class LambdaConfiguration {
        public UUID accessTokenPopulateId;
        public UUID idTokenPopulateId;
        public UUID samlv2PopulateId;
        public UUID selfServiceRegistrationValidationId;
        public UUID userinfoPopulateId;

        @JacksonConstructor
        public LambdaConfiguration() {
        }

        public LambdaConfiguration(LambdaConfiguration other) {
            this.accessTokenPopulateId = other.accessTokenPopulateId;
            this.idTokenPopulateId = other.idTokenPopulateId;
            this.samlv2PopulateId = other.samlv2PopulateId;
            this.selfServiceRegistrationValidationId = other.selfServiceRegistrationValidationId;
            this.userinfoPopulateId = other.userinfoPopulateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LambdaConfiguration)) {
                return false;
            }
            LambdaConfiguration that = (LambdaConfiguration)o;
            return Objects.equals(this.accessTokenPopulateId, that.accessTokenPopulateId) && Objects.equals(this.idTokenPopulateId, that.idTokenPopulateId) && Objects.equals(this.samlv2PopulateId, that.samlv2PopulateId) && Objects.equals(this.selfServiceRegistrationValidationId, that.selfServiceRegistrationValidationId) && Objects.equals(this.userinfoPopulateId, that.userinfoPopulateId);
        }

        public int hashCode() {
            return Objects.hash(this.accessTokenPopulateId, this.idTokenPopulateId, this.samlv2PopulateId, this.selfServiceRegistrationValidationId, this.userinfoPopulateId);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class LoginConfiguration
    implements Buildable<LoginConfiguration> {
        public boolean allowTokenRefresh;
        public boolean generateRefreshTokens;
        public boolean requireAuthentication = true;

        @JacksonConstructor
        public LoginConfiguration() {
        }

        public LoginConfiguration(LoginConfiguration other) {
            this.allowTokenRefresh = other.allowTokenRefresh;
            this.generateRefreshTokens = other.generateRefreshTokens;
            this.requireAuthentication = other.requireAuthentication;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoginConfiguration that = (LoginConfiguration)o;
            return this.allowTokenRefresh == that.allowTokenRefresh && this.generateRefreshTokens == that.generateRefreshTokens && this.requireAuthentication == that.requireAuthentication;
        }

        public int hashCode() {
            return Objects.hash(this.allowTokenRefresh, this.generateRefreshTokens, this.requireAuthentication);
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class PasswordlessConfiguration
    extends Enableable {
        @JacksonConstructor
        public PasswordlessConfiguration() {
        }

        public PasswordlessConfiguration(PasswordlessConfiguration other) {
            this.enabled = other.enabled;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode());
        }

        public String toString() {
            return ToString.toString((Object)this);
        }
    }

    public static class RegistrationConfiguration
    extends Enableable
    implements Buildable<RegistrationConfiguration> {
        public Requirable birthDate = new Requirable();
        public boolean confirmPassword;
        public Requirable firstName = new Requirable();
        public UUID formId;
        public Requirable fullName = new Requirable();
        public Requirable lastName = new Requirable();
        public LoginIdType loginIdType = LoginIdType.email;
        public Requirable middleName = new Requirable();
        public Requirable mobilePhone = new Requirable();
        public Requirable preferredLanguages = new Requirable();
        public RegistrationType type = RegistrationType.basic;

        @JacksonConstructor
        public RegistrationConfiguration() {
        }

        public RegistrationConfiguration(RegistrationConfiguration other) {
            this.birthDate = new Requirable(other.birthDate);
            this.confirmPassword = other.confirmPassword;
            this.enabled = other.enabled;
            this.firstName = new Requirable(other.firstName);
            this.formId = other.formId;
            this.fullName = new Requirable(other.fullName);
            this.lastName = new Requirable(other.lastName);
            this.loginIdType = other.loginIdType;
            this.middleName = new Requirable(other.middleName);
            this.mobilePhone = new Requirable(other.mobilePhone);
            this.preferredLanguages = new Requirable(other.preferredLanguages);
            this.type = other.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegistrationConfiguration that = (RegistrationConfiguration)o;
            return this.confirmPassword == that.confirmPassword && Objects.equals(this.birthDate, that.birthDate) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.formId, that.formId) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.lastName, that.lastName) && this.loginIdType == that.loginIdType && Objects.equals(this.middleName, that.middleName) && Objects.equals(this.mobilePhone, that.mobilePhone) && Objects.equals(this.preferredLanguages, that.preferredLanguages) && this.type == that.type;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.birthDate, this.confirmPassword, this.firstName, this.formId, this.fullName, this.lastName, this.loginIdType, this.middleName, this.mobilePhone, this.preferredLanguages, this.type});
        }

        public String toString() {
            return ToString.toString((Object)this);
        }

        public static enum LoginIdType {
            email,
            username;

        }

        public static enum RegistrationType {
            basic,
            advanced;

        }
    }

    public static class SAMLv2Configuration
    extends Enableable
    implements Buildable<SAMLv2Configuration> {
        public SAMLv2AssertionEncryptionConfiguration assertionEncryptionConfiguration = new SAMLv2AssertionEncryptionConfiguration();
        public String audience;
        @JsonMerge(value=OptBoolean.FALSE)
        public List<URI> authorizedRedirectURLs = new ArrayList<URI>();
        public boolean debug;
        public UUID defaultVerificationKeyId;
        public SAMLv2IdPInitiatedLoginConfiguration initiatedLogin = new SAMLv2IdPInitiatedLoginConfiguration();
        public String issuer;
        public UUID keyId;
        public LoginHintConfiguration loginHintConfiguration = new LoginHintConfiguration(true);
        public SAMLv2Logout logout = new SAMLv2Logout();
        public URI logoutURL;
        public boolean requireSignedRequests;
        public CanonicalizationMethod xmlSignatureC14nMethod = CanonicalizationMethod.exclusive_with_comments;
        public XMLSignatureLocation xmlSignatureLocation = XMLSignatureLocation.Assertion;

        @JacksonConstructor
        public SAMLv2Configuration() {
        }

        public SAMLv2Configuration(SAMLv2Configuration other) {
            this.assertionEncryptionConfiguration = other.assertionEncryptionConfiguration;
            this.audience = other.audience;
            this.authorizedRedirectURLs.addAll(other.authorizedRedirectURLs);
            this.debug = other.debug;
            this.defaultVerificationKeyId = other.defaultVerificationKeyId;
            this.enabled = other.enabled;
            this.initiatedLogin = new SAMLv2IdPInitiatedLoginConfiguration(other.initiatedLogin);
            this.issuer = other.issuer;
            this.keyId = other.keyId;
            this.loginHintConfiguration = new LoginHintConfiguration(other.loginHintConfiguration);
            this.logoutURL = other.logoutURL;
            this.logout = new SAMLv2Logout(other.logout);
            this.requireSignedRequests = other.requireSignedRequests;
            this.xmlSignatureLocation = other.xmlSignatureLocation;
            this.xmlSignatureC14nMethod = other.xmlSignatureC14nMethod;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SAMLv2Configuration)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SAMLv2Configuration that = (SAMLv2Configuration)o;
            return Objects.equals(this.assertionEncryptionConfiguration, that.assertionEncryptionConfiguration) && Objects.equals(this.audience, that.audience) && Objects.equals(this.authorizedRedirectURLs, that.authorizedRedirectURLs) && Objects.equals(this.debug, that.debug) && Objects.equals(this.defaultVerificationKeyId, that.defaultVerificationKeyId) && Objects.equals(this.initiatedLogin, that.initiatedLogin) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.loginHintConfiguration, that.loginHintConfiguration) && Objects.equals(this.logoutURL, that.logoutURL) && Objects.equals(this.requireSignedRequests, that.requireSignedRequests) && Objects.equals((Object)this.xmlSignatureLocation, (Object)that.xmlSignatureLocation) && Objects.equals((Object)this.xmlSignatureC14nMethod, (Object)that.xmlSignatureC14nMethod);
        }

        @Deprecated
        public URI getCallbackURL() {
            if (this.authorizedRedirectURLs.isEmpty()) {
                return null;
            }
            return this.authorizedRedirectURLs.get(0);
        }

        @Deprecated
        public void setCallbackURL(URI callbackURL) {
            if (!this.authorizedRedirectURLs.contains(callbackURL)) {
                this.authorizedRedirectURLs.add(callbackURL);
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.assertionEncryptionConfiguration, this.audience, this.authorizedRedirectURLs, this.debug, this.defaultVerificationKeyId, this.initiatedLogin, this.issuer, this.keyId, this.loginHintConfiguration, this.logoutURL, this.requireSignedRequests, this.xmlSignatureLocation, this.xmlSignatureC14nMethod});
        }

        public static class SAMLv2AssertionEncryptionConfiguration
        extends Enableable
        implements Buildable<SAMLv2AssertionEncryptionConfiguration> {
            public String digestAlgorithm = "SHA256";
            public String encryptionAlgorithm = "AES256GCM";
            public String keyLocation = "Child";
            public String keyTransportAlgorithm = "RSA_OAEP";
            public UUID keyTransportEncryptionKeyId;
            public String maskGenerationFunction = "MGF1_SHA1";

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                SAMLv2AssertionEncryptionConfiguration that = (SAMLv2AssertionEncryptionConfiguration)o;
                return Objects.equals(this.digestAlgorithm, that.digestAlgorithm) && Objects.equals(this.encryptionAlgorithm, that.encryptionAlgorithm) && Objects.equals(this.keyLocation, that.keyLocation) && Objects.equals(this.keyTransportAlgorithm, that.keyTransportAlgorithm) && Objects.equals(this.keyTransportEncryptionKeyId, that.keyTransportEncryptionKeyId) && Objects.equals(this.maskGenerationFunction, that.maskGenerationFunction);
            }

            @Override
            public int hashCode() {
                return Objects.hash(super.hashCode(), this.digestAlgorithm, this.encryptionAlgorithm, this.keyLocation, this.keyTransportAlgorithm, this.keyTransportEncryptionKeyId, this.maskGenerationFunction);
            }

            public String toString() {
                return ToString.toString((Object)this);
            }
        }

        public static class SAMLv2Logout {
            public SAMLLogoutBehavior behavior = SAMLLogoutBehavior.AllParticipants;
            public UUID defaultVerificationKeyId;
            public UUID keyId;
            public boolean requireSignedRequests;
            public SAMLv2SingleLogout singleLogout = new SAMLv2SingleLogout();
            public CanonicalizationMethod xmlSignatureC14nMethod = CanonicalizationMethod.exclusive_with_comments;

            public SAMLv2Logout(SAMLv2Logout other) {
                this.defaultVerificationKeyId = other.defaultVerificationKeyId;
                this.keyId = other.keyId;
                this.behavior = other.behavior;
                this.requireSignedRequests = other.requireSignedRequests;
                this.singleLogout = new SAMLv2SingleLogout(other.singleLogout);
                this.xmlSignatureC14nMethod = other.xmlSignatureC14nMethod;
            }

            @JacksonConstructor
            public SAMLv2Logout() {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SAMLv2Logout that = (SAMLv2Logout)o;
                return this.requireSignedRequests == that.requireSignedRequests && Objects.equals(this.defaultVerificationKeyId, that.defaultVerificationKeyId) && Objects.equals(this.keyId, that.keyId) && this.behavior == that.behavior && Objects.equals(this.singleLogout, that.singleLogout) && this.xmlSignatureC14nMethod == that.xmlSignatureC14nMethod;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.defaultVerificationKeyId, this.keyId, this.behavior, this.requireSignedRequests, this.singleLogout, this.xmlSignatureC14nMethod});
            }

            public String toString() {
                return ToString.toString((Object)this);
            }
        }

        public static enum XMLSignatureLocation {
            Assertion,
            Response;

        }

        public static class SAMLv2SingleLogout
        extends Enableable {
            public UUID keyId;
            public URI url;
            public CanonicalizationMethod xmlSignatureC14nMethod = CanonicalizationMethod.exclusive_with_comments;

            public SAMLv2SingleLogout(SAMLv2SingleLogout other) {
                this.enabled = other.enabled;
                this.keyId = other.keyId;
                this.url = other.url;
                this.xmlSignatureC14nMethod = other.xmlSignatureC14nMethod;
            }

            @JacksonConstructor
            public SAMLv2SingleLogout() {
            }

            public String toString() {
                return ToString.toString((Object)this);
            }
        }

        public static enum SAMLLogoutBehavior {
            AllParticipants,
            OnlyOriginator;

        }
    }
}

