/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.TwoFactorMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(value={"enabled"}, allowGetters=true, allowSetters=false)
public class UserTwoFactorConfiguration
implements Buildable<UserTwoFactorConfiguration> {
    public final List<TwoFactorMethod> methods = new ArrayList<TwoFactorMethod>();
    public final List<String> recoveryCodes = new ArrayList<String>();

    @JacksonConstructor
    public UserTwoFactorConfiguration() {
    }

    public UserTwoFactorConfiguration(UserTwoFactorConfiguration other) {
        other.methods.forEach(m -> this.methods.add(new TwoFactorMethod((TwoFactorMethod)m)));
        this.recoveryCodes.addAll(other.recoveryCodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserTwoFactorConfiguration that = (UserTwoFactorConfiguration)o;
        return Objects.equals(this.methods, that.methods) && Objects.equals(this.recoveryCodes, that.recoveryCodes);
    }

    @JsonIgnore
    public TwoFactorMethod getLastUsedMethod() {
        if (this.methods.size() == 1) {
            return this.methods.get(0);
        }
        return this.methods.stream().filter(m -> m.lastUsed != null && m.lastUsed != false).findFirst().orElse(null);
    }

    @JsonIgnore
    public TwoFactorMethod getMethodById(String id) {
        return this.methods.stream().filter(m -> m.id != null).filter(m -> m.id.equals(id)).findFirst().orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.recoveryCodes);
    }

    public UserTwoFactorConfiguration secure() {
        this.recoveryCodes.clear();
        this.methods.forEach(TwoFactorMethod::secure);
        return this;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

