/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.event.ObjectIdentifiable;
import java.util.Objects;
import java.util.UUID;

public class JWTRefreshEvent
extends BaseEvent
implements Buildable<JWTRefreshEvent>,
ObjectIdentifiable {
    public UUID applicationId;
    public String original;
    public String refreshToken;
    public String token;
    public UUID userId;

    @JacksonConstructor
    public JWTRefreshEvent() {
    }

    public JWTRefreshEvent(EventInfo info, UUID applicationId, String token, String original, String refreshToken, UUID userId) {
        super(info);
        this.applicationId = applicationId;
        this.original = original;
        this.refreshToken = refreshToken;
        this.token = token;
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        JWTRefreshEvent that = (JWTRefreshEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.original, that.original) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.token, that.token) && Objects.equals(this.userId, that.userId);
    }

    @Override
    public UUID getLinkedObjectId() {
        return this.userId;
    }

    @Override
    public void setLinkedObjectId(UUID linkedObjectId) {
    }

    @Override
    public EventType getType() {
        return EventType.JWTRefresh;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.original, this.refreshToken, this.token, this.userId);
    }
}

