/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserLoginFailedReason;
import io.fusionauth.domain.UserLoginFailedReasonCode;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class UserLoginFailedEvent
extends BaseUserEvent
implements Buildable<UserLoginFailedEvent> {
    public UUID applicationId;
    public String authenticationType;
    @Deprecated
    public String ipAddress;
    public UserLoginFailedReason reason = new UserLoginFailedReason(UserLoginFailedReasonCode.Credentials);

    @JacksonConstructor
    public UserLoginFailedEvent() {
    }

    @Deprecated
    public UserLoginFailedEvent(EventInfo info, UUID applicationId, String authenticationType, User user) {
        super(info, user);
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        if (info != null && info.ipAddress != null) {
            this.ipAddress = info.ipAddress;
        }
    }

    public UserLoginFailedEvent(EventInfo info, UUID applicationId, String authenticationType, UserLoginFailedReason reason, User user) {
        super(info, user);
        this.applicationId = applicationId;
        this.authenticationType = authenticationType;
        this.user = user;
        if (info != null && info.ipAddress != null) {
            this.ipAddress = info.ipAddress;
        }
        this.reason = reason;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UserLoginFailedEvent that = (UserLoginFailedEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.authenticationType, that.authenticationType) && Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.reason, that.reason);
    }

    @Override
    public EventType getType() {
        return EventType.UserLoginFailed;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.authenticationType, this.ipAddress, this.reason);
    }
}

