/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.search;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.WebhookEventResult;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.search.BaseSearchCriteria;
import io.fusionauth.domain.util.SQLTools;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class WebhookEventLogSearchCriteria
extends BaseSearchCriteria
implements Buildable<WebhookEventLogSearchCriteria> {
    public static final Map<String, String> SortableFields = new LinkedHashMap<String, String>();
    public ZonedDateTime end;
    public String event;
    public WebhookEventResult eventResult;
    public EventType eventType;
    public ZonedDateTime start;

    @JacksonConstructor
    public WebhookEventLogSearchCriteria() {
    }

    @Override
    public WebhookEventLogSearchCriteria prepare() {
        if (this.orderBy == null) {
            this.orderBy = this.defaultOrderBy();
        }
        this.orderBy = SQLTools.normalizeOrderBy(this.orderBy, SortableFields);
        this.event = SQLTools.toSearchString(this.event);
        return this;
    }

    @Override
    public Set<String> supportedOrderByColumns() {
        return SortableFields.keySet();
    }

    @Override
    protected String defaultOrderBy() {
        return "sequence DESC";
    }

    static {
        SortableFields.put("eventResult", "w.event_result");
        SortableFields.put("eventType", "w.event_type");
        SortableFields.put("id", "w.id");
        SortableFields.put("insertInstant", "w.insert_instant");
        SortableFields.put("lastAttemptInstant", "w.last_attempt_instant");
        SortableFields.put("linkedObjectId", "w.linked_object_id");
        SortableFields.put("sequence", "w.sequence");
    }
}

