/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.HTTPHeaders;
import io.fusionauth.domain.event.EventType;
import io.fusionauth.domain.util.Normalizer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class Webhook
implements Buildable<Webhook> {
    public List<UUID> applicationIds = new ArrayList<UUID>();
    public Integer connectTimeout;
    @JsonUnwrapped
    public WebhookData data = new WebhookData();
    public String description;
    public boolean global;
    public HTTPHeaders headers = new HTTPHeaders();
    public String httpAuthenticationPassword;
    public String httpAuthenticationUsername;
    public UUID id;
    public Integer readTimeout;
    public String sslCertificate;
    public URI url;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Webhook)) {
            return false;
        }
        Webhook that = (Webhook)o;
        this.applicationIds.sort(UUID::compareTo);
        that.applicationIds.sort(UUID::compareTo);
        return Objects.equals(this.global, that.global) && Objects.equals(this.applicationIds, that.applicationIds) && Objects.equals(this.connectTimeout, that.connectTimeout) && Objects.equals(this.data, that.data) && Objects.equals(this.description, that.description) && Objects.equals(this.headers, that.headers) && Objects.equals(this.httpAuthenticationPassword, that.httpAuthenticationPassword) && Objects.equals(this.httpAuthenticationUsername, that.httpAuthenticationUsername) && Objects.equals(this.readTimeout, that.readTimeout) && Objects.equals(this.sslCertificate, that.sslCertificate) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.applicationIds, this.connectTimeout, this.description, this.global, this.headers, this.httpAuthenticationPassword, this.httpAuthenticationUsername, this.readTimeout, this.sslCertificate, this.url);
    }

    public void normalize() {
        this.headers.normalize();
        this.httpAuthenticationPassword = Normalizer.trim(this.httpAuthenticationPassword);
        this.httpAuthenticationUsername = Normalizer.trim(this.httpAuthenticationUsername);
        this.sslCertificate = Normalizer.trim(this.sslCertificate);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static class WebhookData {
        public Map<EventType, Boolean> eventsEnabled = new HashMap<EventType, Boolean>();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WebhookData)) {
                return false;
            }
            WebhookData that = (WebhookData)o;
            return Objects.equals(this.eventsEnabled, that.eventsEnabled);
        }

        public int hashCode() {
            return Objects.hash(this.eventsEnabled);
        }
    }
}

