/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.oauth2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.oauth2.OAuthResponse;

public class OAuthError
implements OAuthResponse {
    @JsonProperty(value="change_password_id")
    public String changePasswordId;
    @JsonProperty(value="error_description")
    public String description;
    public OAuthErrorType error;
    @JsonProperty(value="error_uri")
    public String errorURI;
    @JsonProperty(value="error_reason")
    public OAuthErrorReason reason;
    @JsonProperty(value="two_factor_id")
    public String twoFactorId;

    @JacksonConstructor
    public OAuthError() {
    }

    public OAuthError(OAuthErrorType error, OAuthErrorReason reason, String description) {
        this.error = error;
        this.reason = reason;
        this.description = description;
    }

    public OAuthError(OAuthErrorType error, String description) {
        this.description = description;
        this.error = error;
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public static enum OAuthErrorType {
        invalid_request,
        invalid_client,
        invalid_grant,
        invalid_token,
        unauthorized_client,
        invalid_scope,
        server_error,
        unsupported_grant_type,
        unsupported_response_type,
        change_password_required,
        two_factor_required;

    }

    public static enum OAuthErrorReason {
        auth_code_not_found,
        access_token_malformed,
        access_token_expired,
        access_token_unavailable_for_processing,
        access_token_failed_processing,
        refresh_token_not_found,
        invalid_client_id,
        invalid_user_credentials,
        invalid_grant_type,
        invalid_origin,
        invalid_pkce_code_verifier,
        invalid_pkce_code_challenge,
        invalid_pkce_code_challenge_method,
        invalid_redirect_uri,
        invalid_response_type,
        grant_type_disabled,
        missing_client_id,
        missing_code,
        missing_grant_type,
        missing_redirect_uri,
        missing_refresh_token,
        missing_response_type,
        missing_token,
        login_prevented,
        user_expired,
        user_not_found,
        client_authentication_missing,
        invalid_client_authentication_scheme,
        invalid_client_authentication,
        client_id_mismatch,
        unknown;

    }
}

