/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.commons.stats.assertion.AssertionPath;
import io.gatling.commons.stats.assertion.Condition;
import io.gatling.commons.stats.assertion.CountMetric;
import io.gatling.commons.stats.assertion.Stat;
import io.gatling.commons.stats.assertion.Target;
import io.gatling.commons.stats.assertion.TimeMetric;
import io.gatling.core.Predef;
import io.gatling.javaapi.core.internal.Converters;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public final class Assertion {
    private final io.gatling.commons.stats.assertion.Assertion wrapped;

    Assertion(io.gatling.commons.stats.assertion.Assertion assertion) {
        this.wrapped = assertion;
    }

    public io.gatling.commons.stats.assertion.Assertion asScala() {
        return this.wrapped;
    }

    public static final class WithPathAndTarget<T extends Number> {
        private final AssertionPath path;
        private final Target target;

        private WithPathAndTarget(AssertionPath assertionPath, Target target) {
            this.path = assertionPath;
            this.target = target;
        }

        private Assertion next(Condition condition) {
            return new Assertion(new io.gatling.commons.stats.assertion.Assertion(this.path, this.target, condition));
        }

        @NonNull
        public Assertion lt(T t) {
            return this.next((Condition)new Condition.Lt(((Number)t).doubleValue()));
        }

        @NonNull
        public Assertion lte(T t) {
            return this.next((Condition)new Condition.Lte(((Number)t).doubleValue()));
        }

        @NonNull
        public Assertion gt(T t) {
            return this.next((Condition)new Condition.Gt(((Number)t).doubleValue()));
        }

        @NonNull
        public Assertion gte(T t) {
            return this.next((Condition)new Condition.Gte(((Number)t).doubleValue()));
        }

        @NonNull
        public Assertion between(T t, T t2) {
            return this.between(t, t2, true);
        }

        @NonNull
        public Assertion between(T t, T t2, boolean bl) {
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue(), ((Number)t2).doubleValue(), bl));
        }

        @NonNull
        public Assertion around(T t, T t2) {
            return this.around(t, t2, true);
        }

        @NonNull
        public Assertion around(T t, T t2, boolean bl) {
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue() - ((Number)t2).doubleValue(), ((Number)t).doubleValue() + ((Number)t2).doubleValue(), bl));
        }

        public Assertion deviatesAround(T t, double d) {
            return this.deviatesAround(t, d, true);
        }

        public Assertion deviatesAround(T t, double d, boolean bl) {
            double d2 = Math.floor(((Number)t).doubleValue() * d);
            return this.next((Condition)new Condition.Between(((Number)t).doubleValue() - d2, ((Number)t).doubleValue() + d2, bl));
        }

        @NonNull
        public Assertion is(T t) {
            return this.next((Condition)new Condition.Is(((Number)t).doubleValue()));
        }

        @NonNull
        public Assertion shouldBe(T t) {
            return this.is(t);
        }

        @NonNull
        public Assertion in(T ... TArray) {
            return this.in(Arrays.stream(TArray).collect(Collectors.toSet()));
        }

        @NonNull
        public Assertion within(T ... TArray) {
            return this.in((Number[])TArray);
        }

        @NonNull
        public Assertion in(Set<T> set) {
            return this.next((Condition)new Condition.In(Converters.toScalaSeq(set.stream().map(number -> number.doubleValue()).collect(Collectors.toList())).toList()));
        }

        @NonNull
        public Assertion within(Set<T> set) {
            return this.in(set);
        }
    }

    public static final class WithPathAndCountMetric {
        private final AssertionPath path;
        private final CountMetric metric;

        private WithPathAndCountMetric(AssertionPath assertionPath, CountMetric countMetric) {
            this.path = assertionPath;
            this.metric = countMetric;
        }

        @NonNull
        public WithPathAndTarget<Long> count() {
            return new WithPathAndTarget<Long>(this.path, (Target)new Target.Count(this.metric));
        }

        @NonNull
        public WithPathAndTarget<Double> percent() {
            return new WithPathAndTarget<Double>(this.path, (Target)new Target.Percent(this.metric));
        }
    }

    public static final class WithPathAndTimeMetric {
        private final AssertionPath path;
        private final TimeMetric metric;

        private WithPathAndTimeMetric(AssertionPath assertionPath, TimeMetric timeMetric) {
            this.path = assertionPath;
            this.metric = timeMetric;
        }

        private WithPathAndTarget<Integer> next(Stat stat) {
            return new WithPathAndTarget<Integer>(this.path, (Target)new Target.Time(this.metric, stat));
        }

        @NonNull
        public WithPathAndTarget<Integer> min() {
            return this.next((Stat)Stat.Min$.MODULE$);
        }

        @NonNull
        public WithPathAndTarget<Integer> max() {
            return this.next((Stat)Stat.Max$.MODULE$);
        }

        @NonNull
        public WithPathAndTarget<Integer> mean() {
            return this.next((Stat)Stat.Mean$.MODULE$);
        }

        @NonNull
        public WithPathAndTarget<Integer> stdDev() {
            return this.next((Stat)Stat.StandardDeviation$.MODULE$);
        }

        @NonNull
        public WithPathAndTarget<Integer> percentile1() {
            return this.percentile(Predef.configuration().reports().indicators().percentile1());
        }

        @NonNull
        public WithPathAndTarget<Integer> percentile2() {
            return this.percentile(Predef.configuration().reports().indicators().percentile2());
        }

        @NonNull
        public WithPathAndTarget<Integer> percentile3() {
            return this.percentile(Predef.configuration().reports().indicators().percentile3());
        }

        @NonNull
        public WithPathAndTarget<Integer> percentile4() {
            return this.percentile(Predef.configuration().reports().indicators().percentile4());
        }

        @NonNull
        public WithPathAndTarget<Integer> percentile(double d) {
            return this.next((Stat)new Stat.Percentile(d));
        }
    }

    public static final class WithPath {
        private final AssertionPath path;

        WithPath(AssertionPath assertionPath) {
            this.path = assertionPath;
        }

        @NonNull
        public WithPathAndTimeMetric responseTime() {
            return new WithPathAndTimeMetric(this.path, (TimeMetric)TimeMetric.ResponseTime$.MODULE$);
        }

        @NonNull
        public WithPathAndCountMetric allRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.AllRequests$.MODULE$);
        }

        @NonNull
        public WithPathAndCountMetric failedRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.FailedRequests$.MODULE$);
        }

        @NonNull
        public WithPathAndCountMetric successfulRequests() {
            return new WithPathAndCountMetric(this.path, (CountMetric)CountMetric.SuccessfulRequests$.MODULE$);
        }

        @NonNull
        public WithPathAndTarget<Double> requestsPerSec() {
            return new WithPathAndTarget<Double>(this.path, (Target)Target.MeanRequestsPerSecond$.MODULE$);
        }
    }
}

