/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.Predef;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.BatchableFeederBuilder;
import io.gatling.core.feeder.FeederBuilderBase;
import io.gatling.core.feeder.SeparatedValuesParser;
import io.gatling.core.json.JsonParsers;
import io.gatling.javaapi.core.internal.Converters;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import scala.Function0;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;

public interface FeederBuilder<T> {
    @NonNull
    public FeederBuilder<T> queue();

    @NonNull
    public FeederBuilder<T> random();

    @NonNull
    public FeederBuilder<T> shuffle();

    @NonNull
    public FeederBuilder<T> circular();

    @NonNull
    public FeederBuilder<Object> transform(@NonNull BiFunction<String, T, Object> var1);

    @NonNull
    public List<java.util.Map<String, Object>> readRecords();

    public int recordsCount();

    @NonNull
    public FeederBuilder<T> shard();

    public Function0<Iterator<Map<String, Object>>> asScala();

    public static final class Impl<T>
    implements Batchable<T> {
        private final BatchableFeederBuilder<T> wrapped;

        @NonNull
        static Batchable<String> csv(@NonNull String string) {
            return Impl.csv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @NonNull
        static Batchable<String> csv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.csv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @NonNull
        static Batchable<String> ssv(@NonNull String string) {
            return Impl.ssv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @NonNull
        static Batchable<String> ssv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.ssv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @NonNull
        static Batchable<String> tsv(@NonNull String string) {
            return Impl.tsv(string, SeparatedValuesParser.DefaultQuoteChar());
        }

        @NonNull
        static Batchable<String> tsv(@NonNull String string, char c) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.tsv((String)string, (char)c, (GatlingConfiguration)Predef.configuration()));
        }

        @NonNull
        static Batchable<String> separatedValues(@NonNull String string, char c) {
            return Impl.separatedValues(string, c, SeparatedValuesParser.DefaultQuoteChar());
        }

        @NonNull
        static Batchable<String> separatedValues(@NonNull String string, char c, char c2) {
            return new Impl<String>((FeederBuilderBase<String>)Predef.separatedValues((String)string, (char)c, (char)c2, (GatlingConfiguration)Predef.configuration()));
        }

        @NonNull
        static FileBased<Object> jsonFile(@NonNull String string) {
            return new Impl<Object>((FeederBuilderBase<Object>)Predef.jsonFile((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        @NonNull
        static FeederBuilder<Object> jsonUrl(@NonNull String string) {
            return new Impl<Object>(Predef.jsonUrl((String)string, (JsonParsers)Predef.defaultJsonParsers(), (GatlingConfiguration)Predef.configuration()));
        }

        public Impl(@NonNull FeederBuilderBase<T> feederBuilderBase) {
            this.wrapped = (BatchableFeederBuilder)feederBuilderBase;
        }

        private Impl<T> make(Function<BatchableFeederBuilder<T>, FeederBuilderBase<T>> function) {
            return new Impl<T>(function.apply(this.wrapped));
        }

        @Override
        @NonNull
        public Batchable<T> queue() {
            return this.make(BatchableFeederBuilder::queue);
        }

        @Override
        @NonNull
        public Batchable<T> random() {
            return this.make(BatchableFeederBuilder::random);
        }

        @Override
        @NonNull
        public Batchable<T> shuffle() {
            return this.make(BatchableFeederBuilder::shuffle);
        }

        @Override
        @NonNull
        public Batchable<T> circular() {
            return this.make(BatchableFeederBuilder::circular);
        }

        @Override
        @NonNull
        public FeederBuilder<Object> transform(final @NonNull BiFunction<String, T, Object> biFunction) {
            return new Impl<Object>((FeederBuilderBase<Object>)this.wrapped.transform(new PartialFunction<Tuple2<String, T>, Object>(){

                public boolean isDefinedAt(Tuple2<String, T> tuple2) {
                    return true;
                }

                public Object apply(Tuple2<String, T> tuple2) {
                    return biFunction.apply((String)tuple2._1, tuple2._2);
                }
            }));
        }

        @Override
        @NonNull
        public List<java.util.Map<String, Object>> readRecords() {
            return Converters.toJavaList(this.wrapped.readRecords()).stream().map(Converters::toJavaMap).collect(Collectors.toList());
        }

        @Override
        public int recordsCount() {
            return this.wrapped.recordsCount();
        }

        @Override
        @NonNull
        public Batchable<T> shard() {
            return this.make(BatchableFeederBuilder::shard);
        }

        @Override
        @NonNull
        public Batchable<T> unzip() {
            return this.make(BatchableFeederBuilder::unzip);
        }

        @Override
        @NonNull
        public Batchable<T> eager() {
            return this.make(BatchableFeederBuilder::eager);
        }

        @Override
        @NonNull
        public Batchable<T> batch() {
            return this.make(BatchableFeederBuilder::batch);
        }

        @Override
        @NonNull
        public Batchable<T> batch(int n) {
            return this.make(batchableFeederBuilder -> batchableFeederBuilder.batch(n));
        }

        @Override
        public Function0<Iterator<Map<String, Object>>> asScala() {
            return this.wrapped;
        }
    }

    public static interface Batchable<T>
    extends FileBased<T> {
        @Override
        @NonNull
        public Batchable<T> queue();

        @Override
        @NonNull
        public Batchable<T> random();

        @Override
        @NonNull
        public Batchable<T> shuffle();

        @Override
        @NonNull
        public Batchable<T> circular();

        @Override
        @NonNull
        public Batchable<T> shard();

        @Override
        @NonNull
        public Batchable<T> unzip();

        @NonNull
        public Batchable<T> eager();

        @NonNull
        public Batchable<T> batch();

        @NonNull
        public Batchable<T> batch(int var1);
    }

    public static interface FileBased<T>
    extends FeederBuilder<T> {
        @Override
        @NonNull
        public FileBased<T> queue();

        @Override
        @NonNull
        public FileBased<T> random();

        @Override
        @NonNull
        public FileBased<T> shuffle();

        @Override
        @NonNull
        public FileBased<T> circular();

        @Override
        @NonNull
        public FileBased<T> shard();

        @NonNull
        public FileBased<T> unzip();
    }
}

