/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.core.loop;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.StructureBuilder;
import io.gatling.javaapi.core.exec.Executable;
import io.gatling.javaapi.core.internal.Executables;
import io.gatling.javaapi.core.internal.loop.ScalaDuring;
import java.time.Duration;
import java.util.UUID;
import java.util.function.Function;

public interface During<T extends StructureBuilder<T, W>, W extends io.gatling.core.structure.StructureBuilder<W>> {
    public T make(Function<W, W> var1);

    @NonNull
    default public On<T> during(long l) {
        return this.during(Duration.ofSeconds(l));
    }

    @NonNull
    default public On<T> during(long l, boolean bl) {
        return this.during(Duration.ofSeconds(l), bl);
    }

    @NonNull
    default public On<T> during(long l, String string) {
        return this.during(Duration.ofSeconds(l), string);
    }

    @NonNull
    default public On<T> during(long l, String string, boolean bl) {
        return this.during(Duration.ofSeconds(l), string, bl);
    }

    @NonNull
    default public On<T> during(@NonNull Duration duration) {
        return this.during((Session session) -> duration);
    }

    @NonNull
    default public On<T> during(@NonNull Duration duration, boolean bl) {
        return this.during((Session session) -> duration, bl);
    }

    @NonNull
    default public On<T> during(@NonNull Duration duration, @NonNull String string) {
        return this.during((Session session) -> duration, string, true);
    }

    @NonNull
    default public On<T> during(@NonNull Duration duration, @NonNull String string, boolean bl) {
        return new On(ScalaDuring.apply(this, duration, string, bl));
    }

    @NonNull
    default public On<T> during(@NonNull String string) {
        return this.during(string, UUID.randomUUID().toString());
    }

    @NonNull
    default public On<T> during(@NonNull String string, boolean bl) {
        return this.during(string, UUID.randomUUID().toString(), bl);
    }

    @NonNull
    default public On<T> during(@NonNull String string, @NonNull String string2) {
        return this.during(string, string2, true);
    }

    @NonNull
    default public On<T> during(@NonNull String string, @NonNull String string2, boolean bl) {
        return new On(ScalaDuring.apply(this, string, string2, bl));
    }

    @NonNull
    default public On<T> during(@NonNull Function<Session, Duration> function) {
        return this.during(function, UUID.randomUUID().toString());
    }

    @NonNull
    default public On<T> during(@NonNull Function<Session, Duration> function, boolean bl) {
        return this.during(function, UUID.randomUUID().toString(), bl);
    }

    @NonNull
    default public On<T> during(@NonNull Function<Session, Duration> function, @NonNull String string) {
        return this.during(function, string, true);
    }

    @NonNull
    default public On<T> during(@NonNull Function<Session, Duration> function, @NonNull String string, boolean bl) {
        return new On(ScalaDuring.apply(this, function, string, bl));
    }

    public static final class On<T extends StructureBuilder<T, ?>> {
        private final ScalaDuring.Loop<T, ?> wrapped;

        On(ScalaDuring.Loop<T, ?> loop) {
            this.wrapped = loop;
        }

        @NonNull
        public T on(@NonNull Executable executable, Executable ... executableArray) {
            return this.wrapped.loop(Executables.toChainBuilder(executable, executableArray));
        }
    }
}

