/**
 * Copyright 2011-2014 eBusiness Information, Groupe Excilys (www.ebusinessinformation.fr)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.gatling.http

object HeaderNames {
  val Accept = "Accept"
  val AcceptCharset = "Accept-Charset"
  val AcceptEncoding = "Accept-Encoding"
  val AcceptLanguage = "Accept-Language"
  val AcceptRanges = "Accept-Ranges"
  val AcceptPath = "Accept-Patch"
  val Age = "Age"
  val Allow = "Allow"
  val Authorization = "Authorization"
  val CacheControl = "Cache-Control"
  val Connection = "Connection"
  val ContentBase = "Content-Base"
  val ContentEncoding = "Content-Encoding"
  val ContentLanguage = "Content-Language"
  val ContentLength = "Content-Length"
  val ContentLocation = "Content-Location"
  val ContentTransferEncoding = "Content-Transfer-Encoding"
  val ContentMD5 = "Content-MD5"
  val ContentRange = "Content-Range"
  val ContentType = "Content-Type"
  val Cookie = "Cookie"
  val Date = "Date"
  val DNT = "DNT"
  val ETag = "ETag"
  val Expect = "Expect"
  val Expires = "Expires"
  val From = "From"
  val Host = "Host"
  val IfMatch = "If-Match"
  val IfModifiedSince = "If-Modified-Since"
  val IfNoneMatch = "If-None-Match"
  val IfRange = "If-Range"
  val IfUnmodifiedSince = "If-Unmodified-Since"
  val LastModified = "Last-Modified"
  val Location = "Location"
  val MaxForwards = "Max-Forwards"
  val Origin = "Origin"
  val Pragma = "Pragma"
  val ProxyAuthenticate = "Proxy-Authenticate"
  val ProxyAuthorization = "Proxy-Authorization"
  val Range = "Range"
  val Referer = "Referer"
  val RetryAfter = "Retry-After"
  val SecWebSocketKey1 = "Sec-WebSocket-Key1"
  val SecWebSocketKey2 = "Sec-WebSocket-Key2"
  val SecWebSocketLocation = "Sec-WebSocket-Location"
  val SecWebSocketOrigin = "Sec-WebSocket-Origin"
  val SecWebSocketProtocol = "Sec-WebSocket-Protocol"
  val SecWebSocketVersion = "Sec-WebSocket-Version"
  val SecWebSocketKey = "Sec-WebSocket-Key"
  val SecWebSocketAccept = "Sec-WebSocket-Accept"
  val Server = "Server"
  val SetCookie = "Set-Cookie"
  val SetCookie2 = "Set-Cookie2"
  val TE = "TE"
  val Trailer = "Trailer"
  val TransferEncoding = "Transfer-Encoding"
  val Upgrade = "Upgrade"
  val UserAgent = "User-Agent"
  val VARY = "Vary"
  val Via = "Via"
  val Warning = "Warning"
  val WebSocketLocation = "WebSocket-Location"
  val WebSocketOrigin = "WebSocket-Origin"
  val WebSocketProtocol = "WebSocket-Protocol"
  val WWWAuthenticate = "WWW-Authenticate"
  val XRequestedWith = "X-Requested-With"
}

object HeaderValues {
  val ApplicationJavascript = "application/javascript"
  val ApplicationJson = "application/json"
  val ApplicationOctetStream = "application/octet-stream"
  val ApplicationPdf = "application/pdf"
  val ApplicationZip = "application/zip"
  val ApplicationGzip = "application/x-gzip"
  val ApplicationXml = "application/xml"
  val ApplicationXhtml = "application/xhtml+xml"
  val ApplicationFormUrlEncoded = "application/x-www-form-urlencoded"
  val AudioMp4 = "audio/mp4"
  val AudioMpeg = "audio/mpeg"
  val AudioOgg = "audio/ogg"
  val AudioVorbis = "audio/vorbis"
  val AudioWebm = "audio/webm"
  val ImagePng = "image/png"
  val ImageJpeg = "image/jpeg"
  val ImageGif = "image/gif"
  val ImageSvg = "image/svg+xml"
  val MultipartFormData = "multipart/form-data"
  val TextCss = "text/css"
  val TextCsv = "text/csv"
  val TextHtml = "text/html"
  val TextJavascript = "text/javascript"
  val TextPlain = "text/plain"
  val TextXml = "text/xml"
  val VideoMpeg = "video/mpeg"
  val VideoMp4 = "video/mp4"
  val VideoOgg = "video/ogg"
  val VideoWebm = "video/webm"
  val VideoQuicktime = "video/quicktime"
  val NoCache = "no-cache"
  val NoStore = "no-store"
  val XmlHttpRequest = "XMLHttpRequest"
}
