/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.proxy;

import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.realm.BasicRealm;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public final class SocksProxyServer
extends ProxyServer {
    private final boolean socks5;

    public SocksProxyServer(String string, int n, BasicRealm basicRealm, boolean bl) throws UnknownHostException {
        super(string, n, basicRealm);
        this.socks5 = bl;
    }

    @Override
    public ProxyHandler newProxyHandler() {
        if (this.socks5) {
            return this.realm != null ? new Socks5ProxyHandler((SocketAddress)this.address, this.realm.getUsername(), this.realm.getPassword()) : new Socks5ProxyHandler((SocketAddress)this.address);
        }
        return this.realm != null ? new Socks4ProxyHandler((SocketAddress)this.address, this.realm.getUsername()) : new Socks4ProxyHandler((SocketAddress)this.address);
    }

    public String toString() {
        return "SocksProxyServer{socks5=" + this.socks5 + ", host='" + this.host + "', port=" + this.port + ", realm=" + String.valueOf(this.realm) + "}";
    }
}

