/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.ssl.Tls;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class SslHandlers {
    public static SslHandler newSslHandler(SslContext sslContext, ByteBufAllocator byteBufAllocator, String string, int n, HttpClientConfig httpClientConfig) {
        SSLParameters sSLParameters;
        SSLEngine sSLEngine = httpClientConfig.isEnableSni() ? sslContext.newEngine(byteBufAllocator, Tls.domain(string), n) : sslContext.newEngine(byteBufAllocator);
        sSLEngine.setUseClientMode(true);
        if (httpClientConfig.isEnableHostnameVerification()) {
            sSLParameters = sSLEngine.getSSLParameters();
            sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sSLEngine.setSSLParameters(sSLParameters);
        }
        sSLParameters = new SslHandler(sSLEngine);
        if (httpClientConfig.getHandshakeTimeout() > 0L) {
            sSLParameters.setHandshakeTimeoutMillis(httpClientConfig.getHandshakeTimeout());
        }
        return sSLParameters;
    }
}

