/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MessageDigestUtils {
    private static final ThreadLocal<MessageDigest> MD5_MESSAGE_DIGESTS = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported on this platform");
        }
    });
    private static final ThreadLocal<MessageDigest> SHA1_MESSAGE_DIGESTS = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("SHA1 not supported on this platform");
        }
    });

    private MessageDigestUtils() {
    }

    public static MessageDigest pooledMd5MessageDigest() {
        MessageDigest messageDigest = MD5_MESSAGE_DIGESTS.get();
        messageDigest.reset();
        return messageDigest;
    }

    public static MessageDigest pooledSha1MessageDigest() {
        MessageDigest messageDigest = SHA1_MESSAGE_DIGESTS.get();
        messageDigest.reset();
        return messageDigest;
    }
}

